/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing;

import com.intellij.codeHighlighting.DirtyScopeTrackingHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.reparsing.OCLanguageServiceReparsingPass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageServiceReparsingPassFactory
implements Disposable,
DirtyScopeTrackingHighlightingPassFactory {
    private final int myPassId;

    public OCLanguageServiceReparsingPassFactory(@NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        this.myPassId = highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.BEFORE, 4, false, false);
    }

    public int getPassId() {
        return this.myPassId;
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (!OCLanguageUtils.isSupported(file2)) {
            return null;
        }
        if (FileStatusMap.getDirtyTextRange((Editor)editor, (int)this.myPassId) == null) {
            return null;
        }
        return new OCLanguageServiceReparsingPass(file2.getProject(), file2, editor.getDocument());
    }

    public void dispose() {
    }
}

