/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.telemetry;

import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTelemetryEvent {
    @Nullable
    protected static <T> T tryInstantiate(@NotNull String eventName, @NotNull Object rawEvent, @NotNull Function<Map, T> producer) {
        if (!AbstractTelemetryEvent.checkEventName(rawEvent, eventName)) {
            return null;
        }
        Map event = (Map)rawEvent;
        Object eventData = event.get("eventData");
        assert (eventData instanceof Map) : "Why telemetry event data is not a map?";
        return producer.apply((Map)eventData);
    }

    protected static boolean checkEventName(@NotNull Object object, @NotNull String expectedName) {
        String name = AbstractTelemetryEvent.getEventName(object);
        return Objects.equals(expectedName, name);
    }

    @Nullable
    public static String getEventName(@NotNull Object object) {
        if (!(object instanceof Map)) {
            return null;
        }
        Map map2 = (Map)object;
        return ((CharSequence)map2.get("eventName")).toString();
    }
}

