/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangSym;
import com.jetbrains.cidr.lang.daemon.clang.clangd.SourceLocation;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangDaemonContext;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangASTBasedRequest;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromise;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteractionPromiseImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangLineColPosition;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangProperty;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangRequestsHelper;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangGotoDefinitionRequest
extends ClangASTBasedRequest<TextDocumentPositionParams, List<ClangSym>> {
    @NotNull
    private final ClangDaemonContext myContext;

    @NotNull
    public static ClangInteractionPromise<ClangGotoDefinitionRequest> createPromise(@NotNull ClangDaemonContext context2, @NotNull ClangGotoDefinitionRequest request) {
        String url = context2.getUrlConverter().fromUriToUrl(((TextDocumentPositionParams)request.myParams).getTextDocument().getUri());
        return new ClangInteractionPromiseImpl.Builder<ClangGotoDefinitionRequest>(request).addReadAccessedProperties(url, ClangProperty.Ast).create();
    }

    public ClangGotoDefinitionRequest(@NotNull ClangDaemonContext context2, @NotNull TextDocumentPositionParams params) {
        super(context2.getUrlConverter().fromUriToUrl(params.getTextDocument().getUri()), params);
        this.myContext = context2;
    }

    @Override
    @Nullable
    protected CompletableFuture<List<ClangSym>> sendRequestImpl(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        return server.clionDefinition((TextDocumentPositionParams)this.myParams).thenApply(infos -> {
            if (ContainerUtil.isEmpty((Collection)infos)) {
                return null;
            }
            ArrayList<ClangSym> answer = new ArrayList<ClangSym>(infos.size());
            for (SymbolInformation symInfo : infos) {
                Location loc = symInfo.getLocation();
                String targetUrl = this.myContext.getUrlConverter().fromUriToUrl(loc.getUri());
                SourceLocation srcLoc = new SourceLocation(targetUrl, new ClangLineColPosition(loc.getRange().getStart()));
                answer.add(new ClangSym(symInfo.getName(), srcLoc, ClangRequestsHelper.isMacroLSPSymbolKind(symInfo.getKind())));
            }
            return answer;
        });
    }
}

