/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.intellij.util.Consumer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangAbstractNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangInteraction;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server.ClangServer;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangRemoteWorkspace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ClangAbstractRequest<T, R>
extends ClangAbstractNotification<T> {
    @NotNull
    private final CompletableFuture<R> myResponse;
    @NotNull
    private final List<String> myRequestIds = new ArrayList<String>();

    protected ClangAbstractRequest(@NotNull T params) {
        this(params, new CompletableFuture());
    }

    protected ClangAbstractRequest(@NotNull T params, @NotNull CompletableFuture<R> response) {
        super(params);
        this.myResponse = response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final boolean sendNotification(@NotNull ClangServer server, @NotNull ClangRemoteWorkspace ws) {
        java.util.function.Consumer<String> idsConsumer = id -> this.myRequestIds.add((String)id);
        try {
            server.attachRequestsListener(idsConsumer);
            CompletableFuture<R> future = this.sendRequest(server, ws);
            if (future != null) {
                future.whenComplete((res, thr) -> {
                    if (thr != null) {
                        this.myResponse.completeExceptionally((Throwable)thr);
                    } else {
                        this.myResponse.complete(res);
                    }
                });
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable thr2) {
            this.myResponse.completeExceptionally(thr2);
        }
        finally {
            server.detachRequestsListener(idsConsumer);
        }
        return false;
    }

    @NotNull
    public ClangInteraction cancel() {
        return ClangInteraction.newInteraction("CancelRequest").action((Consumer<? super ClangServer>)((Consumer)server -> {
            for (String id : this.myRequestIds) {
                HashMap<String, String> params = new HashMap<String, String>(2);
                params.put("id", id);
                server.getRemoteEndpoint().notify("$/cancelRequest", params);
            }
        })).create();
    }

    @Override
    public void onSkipped(@NotNull ClangRemoteWorkspace ws) {
        this.myResponse.complete(null);
    }

    @Override
    public void onRejected() {
        this.myResponse.complete(null);
    }

    @Override
    public boolean requiresRecover() {
        return true;
    }

    @NotNull
    public CompletableFuture<R> getResponse() {
        return this.myResponse;
    }

    @Nullable
    protected abstract CompletableFuture<R> sendRequest(@NotNull ClangServer var1, @NotNull ClangRemoteWorkspace var2);
}

