/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.PlainTextLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import org.jetbrains.annotations.NotNull;

public class ClangdDebugDumpUsagesAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile curFile;
        if (e.getProject() != null && (curFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE)) != null) {
            ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(e.getProject());
            ClangdDebugDumpUsagesAction.showStatsInEditor(e.getProject(), service.debugDumpUsages(curFile.getUrl()), "Parse stats");
        }
    }

    private static void showStatsInEditor(@NotNull Project project2, @NotNull String text, @NotNull String caption) {
        if (project2.isDisposed()) {
            return;
        }
        FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)new LightVirtualFile(caption, (Language)PlainTextLanguage.INSTANCE, (CharSequence)text), true);
    }
}

