/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.clang.clangd.annotator.ClangProblemGroup;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CLionClangInspectionBridgeProblemGroup
implements SuppressableProblemGroup,
ClangProblemGroup {
    public static final String PROBLEM_NAME = "CLion-Clang warnings";
    @NotNull
    private final String myProblemName;
    @NotNull
    private final String myDiagID;

    public CLionClangInspectionBridgeProblemGroup(@NotNull String problemName, @NotNull String diagID) {
        this.myProblemName = problemName;
        this.myDiagID = diagID;
    }

    public SuppressIntentionAction @NotNull [] getSuppressActions(@Nullable PsiElement element) {
        return SuppressIntentionAction.EMPTY_ARRAY;
    }

    @Nullable
    public String getProblemName() {
        return this.myProblemName;
    }

    @Override
    @Nullable
    public String getDiagnosticID() {
        return this.myDiagID;
    }

    private static final class SuppressActionAdapter
    extends SuppressIntentionAction {
        @NotNull
        private final IntentionAction myDelegate;

        private SuppressActionAdapter(@NotNull IntentionAction action) {
            this.myDelegate = action;
        }

        public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            PsiFile file2 = element.getContainingFile();
            if (file2 != null) {
                this.myDelegate.invoke(project2, editor, file2);
            }
        }

        public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
            PsiFile file2 = element.getContainingFile();
            return file2 != null && this.myDelegate.isAvailable(project2, editor, file2);
        }

        @NotNull
        public String getFamilyName() {
            return this.myDelegate.getFamilyName();
        }

        @NotNull
        public String getText() {
            return this.myDelegate.getText();
        }

        public Icon getIcon(int flags) {
            return this.myDelegate instanceof Iconable ? ((Iconable)this.myDelegate).getIcon(0) : super.getIcon(flags);
        }

        public boolean startInWriteAction() {
            return this.myDelegate.startInWriteAction();
        }

        public String toString() {
            return this.myDelegate.toString();
        }

        @Nullable
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            return this.myDelegate.getElementToMakeWritable(currentFile);
        }
    }
}

