/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.quickfixes.OCMakeFunctionVirtualFix;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import org.jetbrains.annotations.Nullable;

public class OCHiddenNonVirtualFunctionAnnotator
extends OCAnnotator {
    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        PsiElement declaratorParent = declarator.getParent();
        OCSymbol symbol = declarator.getSymbol();
        if (declaratorParent instanceof OCFunctionDeclaration && symbol instanceof OCFunctionSymbol) {
            OCFunctionDeclaration functionDeclaration = (OCFunctionDeclaration)declaratorParent;
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            OCFile file2 = declarator.getContainingOCFile();
            if (file2.isCpp()) {
                this.checkHiddenNonVirtualFunction(functionDeclaration, functionSymbol, functionDeclaration.getProject());
            }
        }
    }

    private void checkHiddenNonVirtualFunction(OCFunctionDeclaration function, OCFunctionSymbol symbol, Project project2) {
        if (symbol.getKind().isConstructorOrDestructor()) {
            return;
        }
        OCFunctionSymbol candidate = OCHiddenNonVirtualFunctionAnnotator.findOverriddenCandidate(symbol, project2);
        if (candidate == null) {
            return;
        }
        OCCompilationContext compilationContext = OCCompilationContext.create(function);
        if (symbol.getParent() != null && !candidate.isVirtual() && candidate.getVisibility() != OCVisibility.PRIVATE) {
            String message = symbol.getNameWithKindUppercase(compilationContext) + " hides a non-virtual function from " + candidate.getParent().getNameWithKindLowercase(compilationContext);
            Annotation annotation = this.addWarningAnnotation(function, OCInspections.HidingNonVirtualFunction.class, "CIDR", message);
            this.registerQuickFix(annotation, new OCMakeFunctionVirtualFix(candidate, false, compilationContext.getProject()));
        }
    }

    @Nullable
    private static OCFunctionSymbol findOverriddenCandidate(OCFunctionSymbol symbol, Project project2) {
        final Ref nonVirtualRef = new Ref();
        CommonProcessors.FindFirstProcessor<OCFunctionSymbol> virtualFinder = new CommonProcessors.FindFirstProcessor<OCFunctionSymbol>(){

            public boolean process(OCFunctionSymbol symbol) {
                if (symbol.isVirtual()) {
                    return super.process((Object)symbol);
                }
                nonVirtualRef.set((Object)symbol);
                return true;
            }
        };
        new OCFunctionAncestorsQuery(symbol, true, false, project2).forEach((Processor)virtualFinder);
        OCFunctionSymbol virtualFunction = (OCFunctionSymbol)virtualFinder.getFoundValue();
        OCFunctionSymbol nonVirtualFunction = (OCFunctionSymbol)nonVirtualRef.get();
        return virtualFunction != null ? virtualFunction : nonVirtualFunction;
    }
}

