/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.application.options.CodeStyle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.ui.InplaceButton;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettingsProvider;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileWithSelectedExtensionAction<T extends CreateFileDialog>
extends OCNewFileActionBase<T> {
    private static final String DEFAULT_H_EXT = "h";
    private static final String NEW_CPP_HELP_TOPIC_ID = "New_CPP_File_Dialog";

    protected OCNewFileWithSelectedExtensionAction(@Nullable FileType type, @NlsActions.ActionText String text, @NlsActions.ActionDescription String description2, Icon icon) {
        super(type, text, description2, icon);
    }

    @NotNull
    protected ImmutableList<OCCodeStyleSettings.FileExtensionPair> getExtensions(@NotNull Project project2) {
        OCCodeStyleSettings codeStyle = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        return codeStyle.FILE_EXTENSION_PAIRS_ORDERED;
    }

    @NotNull
    private String findSourceExt(@NotNull Project project2, @NotNull String headerExt, @NotNull OCLanguageKind headerKind) {
        for (OCCodeStyleSettings.FileExtensionPair pair : this.getExtensions(project2)) {
            OCLanguageKind sourceKind;
            if (!pair.myHeaderExt.equals(headerExt) || headerKind != (sourceKind = OCLanguageKindCalculator.calculateMinimalKindByExtension(project2, "." + pair.mySourceExt))) continue;
            return pair.mySourceExt;
        }
        return headerKind.getDefaultSourceExtension();
    }

    @NotNull
    private String findHeaderExt(@NotNull Project project2, @NotNull String sourceExt) {
        for (OCCodeStyleSettings.FileExtensionPair pair : this.getExtensions(project2)) {
            if (!pair.mySourceExt.equals(sourceExt)) continue;
            return pair.myHeaderExt;
        }
        return DEFAULT_H_EXT;
    }

    @NotNull
    protected Couple<String> determineExtensions(@NotNull OCFile file2) {
        return this.determineExtensions(file2, null, null);
    }

    @NotNull
    protected Couple<String> determineExtensions(@NotNull OCFile sampleFile, @Nullable String preferredSourceExt, @Nullable String preferredHeaderExt) {
        Project project2 = sampleFile.getProject();
        if (preferredSourceExt == null && preferredHeaderExt == null) {
            if (sampleFile.isHeader()) {
                preferredHeaderExt = FileUtilRt.getExtension((String)sampleFile.getName());
                OCFile implFile = sampleFile.getAssociatedFile();
                if (implFile != null) {
                    preferredSourceExt = FileUtilRt.getExtension((String)implFile.getName());
                }
            } else {
                preferredSourceExt = FileUtilRt.getExtension((String)sampleFile.getName());
            }
        }
        if (preferredSourceExt == null) {
            preferredSourceExt = this.findSourceExt(project2, preferredHeaderExt, sampleFile.getKind());
        } else if (preferredHeaderExt == null) {
            preferredHeaderExt = this.findHeaderExt(project2, preferredSourceExt);
        }
        return Couple.of((Object)preferredSourceExt, (Object)preferredHeaderExt);
    }

    @NotNull
    protected Pair<String, OCCodeStyleSettings.FileExtensionPair> determineNameAndExtension(@NotNull String fileName, boolean isHeader) {
        String selectedExt = FileUtilRt.getExtension((String)fileName);
        OCCodeStyleSettings.FileExtensionPair extensionPair = null;
        if (selectedExt.length() > 0 && (isHeader ? OCFileTypeHelpers.isHeaderFile(fileName) : OCFileTypeHelpers.isSourceFile(fileName))) {
            fileName = FileUtilRt.getNameWithoutExtension((String)fileName);
            ImmutableList<OCCodeStyleSettings.FileExtensionPair> es = this.getExtensions(this.myState.project);
            for (OCCodeStyleSettings.FileExtensionPair e : es) {
                String referenceExt = isHeader ? e.myHeaderExt : e.mySourceExt;
                if (!referenceExt.equals(selectedExt)) continue;
                extensionPair = e;
                break;
            }
            if (extensionPair == null) {
                String srcExt = isHeader ? "cpp" : selectedExt;
                String headerExt = isHeader ? selectedExt : DEFAULT_H_EXT;
                extensionPair = new OCCodeStyleSettings.FileExtensionPair(srcExt, headerExt, NamingConventionStyle.NONE);
            }
        } else {
            extensionPair = ((CreateFileDialog)((Object)this.myState.dialogPeer)).myFileExtensionPair;
            if (extensionPair == null) {
                extensionPair = new OCCodeStyleSettings.FileExtensionPair("cpp", DEFAULT_H_EXT, NamingConventionStyle.NONE);
            }
        }
        return Pair.createNonNull((Object)fileName, (Object)extensionPair);
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        return StandardFileSystems.local().isValidName(selectedName);
    }

    @Override
    @NotNull
    protected T createDialog(@NotNull String defaultName) {
        return (T)((Object)new CreateFileDialog(defaultName));
    }

    protected class CreateFileDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        @Nullable
        protected OCCodeStyleSettings.FileExtensionPair myFileExtensionPair;
        protected TemplateKindCombo myKindCombo;
        @NotNull
        protected ImmutableList<OCCodeStyleSettings.FileExtensionPair> pairs;

        public CreateFileDialog(String defaultName) {
            this("New " + this$0.getTemplatePresentation().getText(), defaultName);
        }

        public CreateFileDialog(String title, String defaultName) {
            super(title, defaultName, PlatformUtils.isCLion() ? OCNewFileWithSelectedExtensionAction.NEW_CPP_HELP_TOPIC_ID : null);
            this.pairs = ContainerUtil.immutableList((Object[])new OCCodeStyleSettings.FileExtensionPair[0]);
        }

        @Override
        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, true);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.createFileTypesCombo(formBuilder);
        }

        protected void createFileTypesCombo(FormBuilder formBuilder) {
            JPanel panel2 = new JPanel(new BorderLayout(5, 0));
            this.myKindCombo = new TemplateKindCombo();
            panel2.add((Component)this.myKindCombo, "Center");
            panel2.add((Component)this.createPreferencesButton(), "East");
            formBuilder.addLabeledComponent(OCBundle.message("create.field.type", new Object[0]), (JComponent)panel2);
            this.reloadExtensions();
            ((JComboBox)this.myKindCombo.getChildComponent()).addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent event) {
                    int selectedIndex;
                    if (event.getStateChange() == 1 && (selectedIndex = CreateFileDialog.this.myKindCombo.getComboBox().getSelectedIndex()) < CreateFileDialog.this.pairs.size()) {
                        CreateFileDialog.this.myFileExtensionPair = (OCCodeStyleSettings.FileExtensionPair)CreateFileDialog.this.pairs.get(selectedIndex);
                    }
                    CreateFileDialog.this.validateOkAction();
                }
            });
            this.myKindCombo.registerUpDownHint((JComponent)this.myNameField);
        }

        protected void reloadExtensions() {
            String prevPairName = this.myFileExtensionPair == null ? null : this.getPresentableName(this.myFileExtensionPair);
            OCCodeStyleSettings.FileExtensionPair currentPair = null;
            this.myKindCombo.clear();
            HashSet<String> processedNames = new HashSet<String>();
            ArrayList<OCCodeStyleSettings.FileExtensionPair> filteredPairs = new ArrayList<OCCodeStyleSettings.FileExtensionPair>();
            for (OCCodeStyleSettings.FileExtensionPair pair : OCNewFileWithSelectedExtensionAction.this.getExtensions(OCNewFileWithSelectedExtensionAction.this.myState.project)) {
                String presentableName = this.getPresentableName(pair);
                if (!processedNames.add(presentableName)) continue;
                this.myKindCombo.addItem(presentableName, null, presentableName);
                filteredPairs.add(pair);
                if (!presentableName.equals(prevPairName)) continue;
                currentPair = pair;
            }
            if (!filteredPairs.isEmpty()) {
                this.pairs = ContainerUtil.immutableList(filteredPairs);
                this.myFileExtensionPair = currentPair == null ? (OCCodeStyleSettings.FileExtensionPair)this.pairs.get(0) : currentPair;
                this.myKindCombo.setSelectedName(this.getPresentableName(this.myFileExtensionPair));
            }
        }

        @Override
        @Nullable
        protected String collectOkActionErrors() {
            if (this.myKindCombo.getComboBox().getItemCount() == 0) {
                return OCBundle.message("fileExtensions.noCompatibleTypes", new Object[0]);
            }
            return super.collectOkActionErrors();
        }

        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair) {
            return "." + pair.mySourceExt + " / ." + pair.myHeaderExt;
        }

        @NotNull
        private InplaceButton createPreferencesButton() {
            return new InplaceButton(OCBundle.message("fileExtensions.editFileTypesTooltip", new Object[0]), AllIcons.General.Settings, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CodeStyleSettings settings = CodeStyle.getSettings((Project)OCNewFileWithSelectedExtensionAction.this.myState.project);
                    OCFileExtensionsSettingsProvider.MyMasterDetailsComponent configurable = OCFileExtensionsSettingsProvider.createConfigurable(settings);
                    boolean ok = ShowSettingsUtil.getInstance().editConfigurable(OCNewFileWithSelectedExtensionAction.this.myState.project, (Configurable)configurable);
                    if (ok) {
                        CreateFileDialog.this.reloadExtensions();
                    }
                }
            });
        }
    }
}

