/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.PsiParser;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.HexdumpLanguage;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.HexdumpLexer;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.parser.HexdumpParser;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.HexdumpFile;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.lang.psi.HexdumpParserTypes;
import org.jetbrains.annotations.NotNull;

public class HexdumpParserDefinition
implements ParserDefinition {
    public static final TokenSet WHITE_SPACES = TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE, HexdumpParserTypes.EOL});
    public static final TokenSet COMMENTS = TokenSet.create((IElementType[])new IElementType[]{HexdumpParserTypes.LINE_COMMENT, HexdumpParserTypes.BLOCK_COMMENT, HexdumpParserTypes.FOLDING_PLACEHOLDER});
    public static final IFileElementType FILE = new IFileElementType(Language.findInstance(HexdumpLanguage.class));

    @NotNull
    public Lexer createLexer(Project project2) {
        return new HexdumpLexer();
    }

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return WHITE_SPACES;
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return COMMENTS;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public PsiParser createParser(Project project2) {
        return new HexdumpParser();
    }

    public IFileElementType getFileNodeType() {
        return FILE;
    }

    public PsiFile createFile(FileViewProvider viewProvider) {
        return new HexdumpFile(viewProvider);
    }

    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }

    @NotNull
    public PsiElement createElement(ASTNode node2) {
        return HexdumpParserTypes.Factory.createElement(node2);
    }
}

