/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ValueRendererUtils {
    public static boolean isQuotedString(@NotNull String s) {
        return ValueRendererUtils.isBeginQuotedString(s) && s.charAt(s.length() - 1) == '\"';
    }

    public static boolean isBeginQuotedString(@NotNull String s) {
        if (s.length() <= 1) {
            return false;
        }
        if (s.charAt(0) == '\"') {
            return true;
        }
        return s.length() >= 3 && (s.charAt(0) == 'L' || s.charAt(0) == 'U') && s.charAt(1) == '\"';
    }

    @NotNull
    public static String getRawString(@NotNull String stringValue) {
        int stringLen = stringValue.length();
        if (stringLen >= 2) {
            char ch1;
            int quotePrefixOffset = 0;
            char ch0 = stringValue.charAt(0);
            if (ch0 == '\"') {
                quotePrefixOffset = 1;
            } else if (stringLen >= 3 && (ch0 == 'L' || ch0 == 'U') && (ch1 = stringValue.charAt(1)) == '\"') {
                quotePrefixOffset = 2;
            }
            if (quotePrefixOffset != 0) {
                if (stringValue.endsWith("\"")) {
                    stringValue = stringValue.substring(quotePrefixOffset, stringLen - 1);
                } else if (stringValue.endsWith("...") && stringLen >= quotePrefixOffset + 4) {
                    char ch = stringValue.charAt(stringLen - 4);
                    stringValue = ch == '\"' ? stringValue.substring(quotePrefixOffset, stringLen - 4) : stringValue.substring(quotePrefixOffset, stringLen - 3);
                }
            }
        }
        stringValue = StringUtil.unescapeStringCharacters((String)stringValue);
        return stringValue;
    }
}

