/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointPropertiesPanel;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExceptionBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public CidrExceptionBreakpointType() {
        this(CidrDebuggerBundle.message("debug.exception.breakpoints", new Object[0]));
    }

    protected CidrExceptionBreakpointType(String title) {
        super("CidrExceptionBreakpoint", title);
    }

    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.invalid", new Object[0]);
        }
        Properties.Type thrown = properties.getWhenThrown();
        Properties.Type caught = properties.getWhenCaught();
        if (thrown == null && caught == null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint", new Object[0]);
        }
        StringBuilder builder2 = new StringBuilder();
        builder2.append("When ");
        if (thrown != null) {
            builder2.append(CidrExceptionBreakpointType.formatType(thrown)).append(" is thrown");
        }
        if (caught != null) {
            if (thrown != null) {
                builder2.append("; ");
            }
            builder2.append(CidrExceptionBreakpointType.formatType(caught)).append(" is caught");
        }
        return builder2.toString();
    }

    private static String formatType(@NotNull Properties.Type thrown) {
        String displayString = thrown.getDisplayString();
        return thrown == Properties.Type.ANY_EXCEPTION ? StringUtil.toLowerCase((String)displayString) : displayString;
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_exception_breakpoint;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    public Properties createProperties() {
        return new Properties();
    }

    public XBreakpoint<Properties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<Properties> creator) {
        XBreakpoint breakpoint = creator.createBreakpoint((XBreakpointProperties)this.createProperties());
        breakpoint.setEnabled(false);
        return breakpoint;
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomPropertiesPanel(@NotNull Project project2) {
        return new CidrExceptionBreakpointPropertiesPanel();
    }

    public XBreakpoint<Properties> addBreakpoint(Project project2, JComponent parentComponent) {
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)project2).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new Properties()));
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        @Attribute(value="thrown")
        @Nullable
        private Type myWhenThrown;
        @Attribute(value="caught")
        @Nullable
        private Type myWhenCaught;

        public Properties() {
            this(Type.ANY_EXCEPTION, null);
        }

        public Properties(@Nullable Type whenThrown, @Nullable Type whenCaught) {
            this.myWhenThrown = whenThrown;
            this.myWhenCaught = whenCaught;
        }

        @Nullable
        public Type getWhenThrown() {
            return this.myWhenThrown;
        }

        public void setWhenThrown(@Nullable Type whenThrown) {
            this.myWhenThrown = whenThrown;
        }

        @Nullable
        public Type getWhenCaught() {
            return this.myWhenCaught;
        }

        public void setWhenCaught(@Nullable Type stopOnCaught) {
            this.myWhenCaught = stopOnCaught;
        }

        @NotNull
        public Properties getState() {
            return this;
        }

        public void loadState(@NotNull Properties state) {
            this.myWhenThrown = state.myWhenThrown;
            this.myWhenCaught = state.myWhenCaught;
        }

        public static enum Type {
            ANY_EXCEPTION("Any"),
            OBJC_EXCEPTION("Objective-C"){

                @Override
                public boolean isAvailable() {
                    return SystemInfo.isMac;
                }
            };

            private final String myDisplayString;

            private Type(String s) {
                this.myDisplayString = s;
            }

            @NotNull
            public String getDisplayString() {
                return this.myDisplayString;
            }

            public boolean isAvailable() {
                return true;
            }
        }
    }
}

