/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportManager;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    @NotNull
    private final LLThread myThread;
    @NotNull
    private final LLFrame myFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    public static final Key THROW_ON_VARIABLES_COLLECTION = Key.create((String)"THROW_ON_VARIABLES_COLLECTION");
    @NotNull
    private final NotNullLazyValue<Pair<XSourcePosition, Boolean>> mySourceOrDisasmLazyValue = NotNullLazyValue.createValue(this::doGetSourceOrDisasm);

    public CidrStackFrame(@NotNull CidrDebugProcess process2, @NotNull LLThread thread, @NotNull LLFrame frame, @Nullable CidrSuspensionCause suspensionCause) {
        this.myProcess = process2;
        this.myThread = thread;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    public long getThreadId() {
        return this.myThread.getId();
    }

    @NotNull
    public LLFrame getFrame() {
        return this.myFrame;
    }

    public int getFrameIndex() {
        return this.myFrame.getIndex();
    }

    public Object getEqualityObject() {
        return Pair.create((Object)this.myThread.getId(), (Object)this.myFrame.getIndex());
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.getSourcePosition(true);
    }

    @Nullable
    public XSourcePosition getSourcePosition(boolean disassembleIfNeeded) {
        Pair sourceOrDisasm = (Pair)this.mySourceOrDisasmLazyValue.getValue();
        return disassembleIfNeeded || (Boolean)sourceOrDisasm.second != false ? (XSourcePosition)sourceOrDisasm.first : null;
    }

    public boolean hasSourceFile() {
        return this.getSourcePosition(false) != null;
    }

    @NotNull
    protected Pair<XSourcePosition, Boolean> doGetSourceOrDisasm() {
        XSourcePosition sourcePosition;
        VirtualFile resolvedFile = this.resolveFile();
        if (resolvedFile != null && (sourcePosition = XDebuggerUtil.getInstance().createPosition(resolvedFile, this.myFrame.getLine())) != null) {
            return Pair.create((Object)sourcePosition, (Object)true);
        }
        return Pair.create((Object)this.myProcess.createDisasmPosition(this.myFrame.getProgramCounter()), (Object)false);
    }

    @Nullable
    private VirtualFile resolveFile() {
        String file2 = this.myFrame.getFile();
        return file2 == null ? null : (VirtualFile)ReadAction.compute(() -> {
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(file2);
            if (vFile == null) {
                return null;
            }
            VirtualFile resolvedFile = ProjectRootUtil.findSymlinkedFileInContent((Project)this.myProcess.getProject(), (VirtualFile)vFile);
            if (CidrDebuggerLog.LOG.isTraceEnabled() && !vFile.equals(resolvedFile)) {
                CidrDebuggerLog.LOG.trace("Debugger path resolved: " + vFile + " -> " + resolvedFile);
            }
            return resolvedFile;
        });
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        String functionName;
        component.setIcon(AllIcons.Debugger.Frame);
        XSourcePosition position = this.getSourcePosition(false);
        boolean hasFunctionName = this.myFrame.hasSymbolInfo();
        String string = functionName = hasFunctionName ? this.myFrame.getFunction() : CidrDebuggerBundle.message("debug.frames.unknownFunction", new Object[0]);
        if (position != null) {
            component.append(functionName, hasFunctionName ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
            component.append(" " + position.getFile().getName() + ":" + (position.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(functionName, hasFunctionName ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.GRAYED_ITALIC_ATTRIBUTES);
            component.append(" " + this.myFrame.getProgramCounter(), SimpleTextAttributes.GRAYED_SMALL_ATTRIBUTES);
        }
    }

    public final void computeChildren(@NotNull XCompositeNode node2) {
        if (CidrDebugProcess.viewsUpdatesDisabledInTests(node2)) {
            return;
        }
        this.myProcess.postCommand(driver -> {
            try {
                this.doComputeChildren(driver, node2);
            }
            catch (DebuggerCommandException e) {
                node2.setErrorMessage(e.getMessage());
            }
            catch (ExecutionException e) {
                node2.setErrorMessage(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                throw e;
            }
        });
    }

    private void doComputeChildren(@NotNull DebuggerDriver driver, @NotNull XCompositeNode node2) throws DebuggerCommandException, ExecutionException {
        if (node2.isObsolete()) {
            return;
        }
        if (this.mySuspensionCause != null) {
            XValueChildrenList list = new XValueChildrenList(1);
            list.add(new XNamedValue(this.mySuspensionCause.type){

                public void computePresentation(@NotNull XValueNode node2, @NotNull XValuePlace place) {
                    node2.setPresentation(((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.icon, null, ((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.reason, false);
                }
            });
            node2.addChildren(list, false);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VARIABLES_COLLECTION);
        XSourcePosition framePosition = this.getSourcePosition(false);
        driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED);
        List<LLValue> vars = this.myFrame.getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT ? ((LLDBDriver)driver).getVariables(this.myThread.getId(), this.myFrame.getIndex(), true, true) : driver.getVariables(this.myThread.getId(), this.myFrame.getIndex());
        this.myProcess.getTypesHelper(this).filterLocalVariables(framePosition, vars, () -> ((XCompositeNode)node2).isObsolete()).whenComplete((filteredVars, t) -> {
            if (filteredVars != null) {
                CidrValue.addLocalValues(filteredVars, this.myProcess, framePosition, this, node2);
            } else {
                vars.forEach(v -> v.setValid(false));
                CidrValue.addLocalValues(vars, this.myProcess, framePosition, this, node2);
            }
        });
    }

    public CidrEvaluator getEvaluator() {
        return CidrDebuggerLanguageSupportManager.getInstance().createEvaluator(this);
    }

    public String toString() {
        return this.myFrame.toString();
    }
}

