/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.GridBag;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrExecutableDataHolder;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationEditorUtil;
import com.jetbrains.cidr.execution.CidrRunConfigurationUtil;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.ui.ComboBoxModelKt;
import com.jetbrains.cidr.ui.ExecutableDataPrinter;
import com.jetbrains.cidr.ui.FileItemPrinter;
import com.jetbrains.cidr.ui.InvalidItem;
import com.jetbrains.cidr.ui.ItemPrinter;
import com.jetbrains.cidr.ui.MutableComboBoxModelEx;
import com.jetbrains.cidr.ui.SelectExecutableActionComboItem;
import com.jetbrains.cidr.ui.SelectFileActionComboItem;
import com.jetbrains.cidr.ui.SortedCollectionComboBoxModel;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrRunConfigurationExecutableEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>> {
    private final SelectFileActionComboItem mySelectExternalExecutable;
    private final BCH myConfigHelper;
    private final JComboBox myExecutableCombo;
    private final MutableComboBoxModelEx<Object> myExecutableComboModel;

    public CidrRunConfigurationExecutableEditor(Project project2, @NotNull BCH configHelper, boolean hasTargetsInSeveralProjects) {
        this(project2, configHelper, (SelectFileActionComboItem)new SelectExecutableActionComboItem(project2), hasTargetsInSeveralProjects);
    }

    public CidrRunConfigurationExecutableEditor(Project project2, @NotNull BCH configHelper, SelectFileActionComboItem selectExternalExecutable, boolean hasTargetsInSeveralProjects) {
        this.myConfigHelper = configHelper;
        this.mySelectExternalExecutable = selectExternalExecutable;
        this.myExecutableComboModel = new SortedCollectionComboBoxModel(ComparisonsKt.compareBy((Function1[])new Function1[]{o -> {
            if (o == null) {
                return Integer.valueOf(0);
            }
            if (o instanceof CidrBuildTarget) {
                return Integer.valueOf(1);
            }
            if (o instanceof InvalidItem) {
                return Integer.valueOf(2);
            }
            if (o instanceof File) {
                return Integer.valueOf(3);
            }
            if (o instanceof SelectFileActionComboItem) {
                return Integer.valueOf(10);
            }
            return Integer.valueOf(4);
        }}));
        this.resetExecutableModel(null, null);
        this.myExecutableCombo = CidrRunConfigurationEditorUtil.createCombo();
        this.myExecutableCombo.setModel(this.myExecutableComboModel);
        this.myExecutableCombo.setRenderer(new MyExecutablesRenderer(hasTargetsInSeveralProjects, new ItemPrinter[0]));
        MessageBus messageBus = project2.getMessageBus();
        this.myExecutableCombo.addItemListener(e -> {
            if (e.getStateChange() == 1) {
                String itemName = CidrRunConfigurationExecutableEditor.getItemName(ComboBoxModelKt.getItemValue((ItemEvent)e));
                ((ExecutableListener)messageBus.syncPublisher(ExecutableListener.TOPIC)).onExecutableSelected(itemName);
            }
        });
    }

    protected void resetExecutableModel(@Nullable Object selection, @Nullable TARGET buildTarget) {
        ArrayList<Object> newItems = new ArrayList<Object>();
        newItems.add(null);
        newItems.addAll(((CidrBuildConfigurationHelper)this.myConfigHelper).getRunTargets(buildTarget));
        newItems.add(this.mySelectExternalExecutable);
        if (selection != null && !newItems.contains(selection)) {
            newItems.add(selection);
        }
        this.myExecutableComboModel.reset(newItems);
        this.myExecutableComboModel.setSelectedItem(selection);
    }

    public void createAdditionalControls(JPanel panel2, GridBag g) {
        JLabel label = new JLabel(CidrBundle.message("build.configuration.executable", new Object[0]) + ":");
        panel2.add((Component)label, g.nextLine().next());
        panel2.add((Component)this.myExecutableCombo, g.next().coverLine());
        label.setLabelFor(this.myExecutableCombo);
    }

    public void onTargetSelected(@Nullable TARGET target) {
        if (target != null && target.isExecutable()) {
            this.myExecutableCombo.setSelectedItem(null);
            this.myExecutableCombo.setSelectedItem(target);
        }
    }

    public void resetEditorFrom(@NotNull CONFIGURATION runConfiguration) {
        ExecutableData executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        Object executable = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        if (executableData != null) {
            if (executableData.target != null) {
                executable = ((CidrBuildConfigurationHelper)this.myConfigHelper).findRunTarget(executableData.target);
            } else if (executableData.path != null) {
                executable = new File(executableData.path);
            }
        }
        CidrBuildTarget<?> target = CidrRunConfigurationUtil.getTarget(runConfiguration);
        this.resetExecutableModel(ComboBoxModelKt.createMaybeInvalidItem((Object)executable, (Object)executableData), target);
    }

    public void applyEditorTo(CONFIGURATION runConfiguration) throws ConfigurationException {
        ExecutableData executableData;
        Object selectedExecutable = ComboBoxModelKt.getSelectedItemValue((JComboBox)this.myExecutableCombo);
        if (selectedExecutable == null) {
            executableData = (ExecutableData)ComboBoxModelKt.getSelectedInvalidItemValue((JComboBox)this.myExecutableCombo);
        } else if (selectedExecutable instanceof CidrBuildTarget) {
            executableData = new ExecutableData(new BuildTargetData((CidrBuildTarget)selectedExecutable));
        } else if (selectedExecutable instanceof File) {
            executableData = new ExecutableData(((File)selectedExecutable).getPath());
        } else {
            OCLog.LOG.assertTrue(selectedExecutable instanceof SelectFileActionComboItem, (Object)("Unexpected selection: " + selectedExecutable));
            executableData = ((CidrExecutableDataHolder)runConfiguration).getExecutableData();
        }
        ((CidrExecutableDataHolder)runConfiguration).setExecutableData(executableData);
    }

    @Nullable
    private static String getItemName(Object item) {
        if (item instanceof File) {
            return ((File)item).getName();
        }
        if (item instanceof CidrBuildTarget) {
            return ((CidrBuildTarget)item).getName();
        }
        return null;
    }

    private static class MyExecutablesRenderer
    extends CidrRunConfigurationEditorUtil.RunConfigurationsRenderer {
        MyExecutablesRenderer(boolean hasTargetsInSeveralProjects, ItemPrinter ... itemPrinters) {
            super(hasTargetsInSeveralProjects, MyExecutablesRenderer.arrayOf((ItemPrinter[])itemPrinters, (ItemPrinter[])new ItemPrinter[]{new FileItemPrinter(false, true), ExecutableDataPrinter.INSTANCE}));
        }

        protected String getSeparatorAbove(@NotNull JList list, Object value, int index) {
            if (index == 0) {
                return null;
            }
            if (value instanceof SelectFileActionComboItem) {
                return "";
            }
            Object previous = list.getModel().getElementAt(index - 1);
            if (value instanceof File && !(previous instanceof File)) {
                return "";
            }
            return super.getSeparatorAbove(list, value, index);
        }
    }

    public static interface ExecutableListener {
        public static final Topic<ExecutableListener> TOPIC = new Topic(ExecutableListener.class.getSimpleName(), ExecutableListener.class);

        public void onExecutableSelected(@Nullable String var1);
    }
}

