/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.doxygen;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.EnterHandler;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.cidr.doxygen.DoxygenUtil;
import com.jetbrains.cidr.doxygen.DxLanguage;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.editor.OCEnterInBlockCommentHandler;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DxEnterInBlockCommentHandler
extends OCEnterInBlockCommentHandler {
    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        Language language = EnterHandler.getLanguage((DataContext)dataContext);
        if (!(language instanceof DxLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return this.doProcessEnter(file2, editor, caretAdvanceRef);
    }

    @Override
    @NotNull
    protected EnterHandlerDelegate.Result doProcessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretAdvanceRef) {
        PsiFile topFile = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        Editor topEditor = InjectedLanguageUtil.getTopLevelEditor((Editor)editor);
        int caretOffset = topEditor.getCaretModel().getOffset();
        if (topFile == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return super.doProcessEnter(topFile, topEditor, (Ref<Integer>)Ref.create((Object)caretOffset));
    }

    @Override
    protected boolean shouldBeProcessed(HighlighterIterator it) {
        return super.shouldBeProcessed(it) && DoxygenUtil.isDoxygenBlockComment(it.getDocument().getCharsSequence().subSequence(it.getStart(), it.getEnd()).toString());
    }

    @Override
    protected Pair<Integer, Integer> generateComment(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int caretInStringOffset, @NotNull StringBuilder result2) {
        result2.append("* ");
        Project project2 = editor.getProject();
        String tagPrefix = DxEnterInBlockCommentHandler.getTagPrefix(file2);
        boolean needSuffix = DxEnterInBlockCommentHandler.needCommentSuffixGeneration(file2, editor, caretOffset, commentText, ch -> "{}".indexOf(ch.charValue()) >= 0);
        if (needSuffix) {
            result2.append(DxEnterInBlockCommentHandler.addBriefIfNeeded(editor, tagPrefix));
        }
        int newCaretPosition = caretOffset + result2.length();
        if (commentText.startsWith("/**") || commentText.startsWith("/*!")) {
            Document document2 = editor.getDocument();
            if (project2 != null) {
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
                document2.insertString(caretOffset, (CharSequence)"*/");
                documentManager.commitDocument(document2);
                PsiComment comment = DxEnterInBlockCommentHandler.findCommentAt(file2, editor, caretOffset);
                if (!DoxygenUtil.hasNextDocCommentSibling(comment) && comment instanceof PsiDocCommentBase) {
                    PsiElement owner = ((PsiDocCommentBase)comment).getOwner();
                    String linePrefix = DxEnterInBlockCommentHandler.getIndentLine(editor, caretOffset) + "*";
                    DxEnterInBlockCommentHandler.generateDocComment(owner, linePrefix, tagPrefix, result2);
                }
                document2.deleteString(caretOffset, caretOffset + 2);
                documentManager.commitDocument(document2);
            }
        }
        int insertCommentSuffixPosition = -1;
        if (needSuffix) {
            insertCommentSuffixPosition = caretOffset + result2.length();
        }
        return Pair.create((Object)insertCommentSuffixPosition, (Object)newCaretPosition);
    }

    @NotNull
    public static String addBriefIfNeeded(@NotNull Editor editor, @NotNull String tagPrefix) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Editor)editor).getCustomSettings(OCCodeStyleSettings.class);
        if (settings.ADD_BRIEF_TAG) {
            return tagPrefix + DoxygenCmd.BRIEF.toString() + " ";
        }
        return "";
    }

    public static void generateDocComment(@Nullable PsiElement owner, @NotNull String linePrefix, @NotNull String tagPrefix, @NotNull StringBuilder result2) {
        if (owner == null) {
            return;
        }
        DoxygenUtil.traverseTemplateParametersList(owner, name -> DxEnterInBlockCommentHandler.appendLine(name, linePrefix, tagPrefix, DoxygenCmd.TPARAM, result2));
        if (owner instanceof OCCallable) {
            OCSymbol symbol;
            OCCallable callable = (OCCallable)owner;
            List<PsiNamedElement> params = callable.getParameters();
            if (params != null) {
                for (PsiNamedElement param : params) {
                    String name2 = DoxygenUtil.getName(param.getName(), param);
                    DxEnterInBlockCommentHandler.appendLine(name2, linePrefix, tagPrefix, DoxygenCmd.PARAM, result2);
                }
            }
            if ((symbol = callable.getSymbol()) != null && !symbol.getKind().isConstructorOrDestructor() && !callable.getReturnType().isVoid()) {
                result2.append("\n").append(linePrefix).append(" ").append(tagPrefix).append((Object)DoxygenCmd.RETURN).append(" ");
            }
        }
    }

    @Override
    protected void flushChanges(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset, @NotNull String commentText, int commentStart, int caretInStringOffset, int insertCommentSuffixPosition, @NotNull StringBuilder indent) {
        Document document2 = editor.getDocument();
        int deleteTo = DxEnterInBlockCommentHandler.countWS(commentText, caretInStringOffset);
        if (CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
            document2.deleteString(caretOffset, commentStart + deleteTo);
        } else if (insertCommentSuffixPosition != -1) {
            insertCommentSuffixPosition += deleteTo - caretInStringOffset;
        }
        int lineEnd = commentText.indexOf(10) != -1 ? commentText.indexOf(10) : commentText.length();
        document2.insertString(caretOffset, (CharSequence)indent);
        if (insertCommentSuffixPosition >= 0) {
            String contextIndent = DxEnterInBlockCommentHandler.getFirstCommentLineIndentFromContext(editor, caretOffset);
            String settingIndent = DxEnterInBlockCommentHandler.customSettingsIndent(editor);
            StringBuilder suffix = new StringBuilder().append('\n').append(contextIndent).append(settingIndent).append("*/");
            if (lineEnd > deleteTo) {
                suffix.append('\n').append(contextIndent);
            }
            document2.insertString(insertCommentSuffixPosition, (CharSequence)suffix);
        }
    }

    public static int countWS(String commentText, int initValue) {
        while (initValue < commentText.length() && "\t ".indexOf(commentText.charAt(initValue)) >= 0) {
            ++initValue;
        }
        return initValue;
    }

    @Nullable
    public static PsiComment findCommentAt(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset) {
        return (PsiComment)PsiTreeUtil.getNonStrictParentOfType((PsiElement)DxEnterInBlockCommentHandler.findElementAt(file2, editor, caretOffset), (Class[])new Class[]{PsiComment.class});
    }

    @Nullable
    public static PsiElement findElementAt(@NotNull PsiFile file2, @NotNull Editor editor, int caretOffset) {
        return file2.findElementAt(caretOffset == editor.getDocument().getTextLength() && caretOffset > 0 ? caretOffset - 1 : caretOffset);
    }

    @NotNull
    private static String getTagPrefix(@NotNull PsiFile refFile) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)refFile, OCCodeStyleSettings.class);
        return settings.TAG_PREFIX_OF_BLOCK_COMMENT == OCCodeStyleSettings.DocTagPrefix.AT ? "@" : "\\";
    }

    private static void appendLine(@NotNull String name, @NotNull String linePrefix, @NotNull String tagPrefix, @NotNull DoxygenCmd tag, @NotNull StringBuilder result2) {
        if (!name.equals("<unnamed>")) {
            result2.append("\n").append(linePrefix).append(" ").append(tagPrefix).append((Object)tag).append(" ").append(name).append(" ");
        }
    }
}

