/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.NotNullFunction;
import com.intellij.util.SofterReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SofterCache<T, V> {
    private final NotNullFunction<? super T, ? extends V> myValueProvider;
    private SofterReference<ConcurrentMap<T, V>> myCache;

    public SofterCache(NotNullFunction<? super T, ? extends V> valueProvider) {
        this.myValueProvider = valueProvider;
    }

    public static <T, V> SofterCache<T, V> create(NotNullFunction<? super T, ? extends V> valueProvider) {
        return new SofterCache<T, V>(valueProvider);
    }

    public void clearCache() {
        this.myCache = null;
    }

    public V getCachedValue(T key) {
        Object value;
        ConcurrentHashMap<T, Object> map2;
        SofterReference<ConcurrentMap<T, V>> ref = this.myCache;
        ConcurrentHashMap<T, Object> concurrentHashMap = map2 = ref == null ? null : (ConcurrentHashMap<T, Object>)ref.get();
        if (map2 == null) {
            map2 = new ConcurrentHashMap<T, Object>();
            this.myCache = new SofterReference(map2);
        }
        if ((value = map2.get(key)) == null) {
            value = this.myValueProvider.fun(key);
            map2.put(key, value);
        }
        return value;
    }
}

