/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analytics.AndroidStudioAnalytics;
import com.intellij.analytics.NullAndroidStudioAnalytics;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LoggedErrorProcessor;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TemporaryDirectory;
import com.intellij.testFramework.TestApplicationManagerKt;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.io.PathKt;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.swing.SwingUtilities;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public abstract class UsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String ORIGINAL_TEMP_DIR;
    private static final Object2LongOpenHashMap<String> TOTAL_SETUP_COST_MILLIS;
    private static final Object2LongOpenHashMap<String> TOTAL_TEARDOWN_COST_MILLIS;
    protected static final Logger LOG;
    @NotNull
    private final Disposable myTestRootDisposable = new TestDisposable();
    private final List<Path> myPathsToKeep = new ArrayList<Path>();
    private Path myTempDir;
    private static final String DEFAULT_SETTINGS_EXTERNALIZED;
    private static final CodeInsightSettings defaultSettings;
    private List<Throwable> mySuppressedExceptions;
    private static final Set<String> DELETE_ON_EXIT_HOOK_DOT_FILES;
    private static final Class<?> DELETE_ON_EXIT_HOOK_CLASS;

    protected void addSuppressedException(@NotNull Throwable e) {
        SmartList list = this.mySuppressedExceptions;
        if (list == null) {
            this.mySuppressedExceptions = list = new SmartList();
        }
        list.add((Throwable)e);
    }

    public UsefulTestCase() {
    }

    public UsefulTestCase(@NotNull String name) {
        super(name);
    }

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        super.setUp();
        if (this.shouldContainTempFiles()) {
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            String testName = null;
            if (policy != null) {
                testName = policy.getPerTestTempDirName();
            }
            if (testName == null) {
                testName = FileUtil.sanitizeFileName((String)this.getTestName(true));
            }
            this.myTempDir = TemporaryDirectory.generateTemporaryPath(TEMP_DIR_MARKER + testName);
            Files.createDirectories(this.myTempDir, new FileAttribute[0]);
            FileUtil.resetCanonicalTempPathCache((String)this.myTempDir.toString());
        }
        AndroidStudioAnalytics.initialize((AndroidStudioAnalytics)new NullAndroidStudioAnalytics());
        boolean isStressTest = this.isStressTest();
        ApplicationInfoImpl.setInStressTest((boolean)isStressTest);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode((!isStressTest ? 1 : 0) != 0);
        if (this.isIconRequired()) {
            IconLoader.deactivate();
        }
    }

    protected boolean isIconRequired() {
        return false;
    }

    protected void tearDown() throws Exception {
        new RunAll(() -> this.disposeRootDisposable(), () -> UsefulTestCase.cleanupSwingDataStructures(), () -> UsefulTestCase.cleanupDeleteOnExitHookList(), () -> Disposer.setDebugMode((boolean)true), () -> {
            if (this.shouldContainTempFiles()) {
                FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                if (this.myPathsToKeep.isEmpty()) {
                    PathKt.delete((Path)this.myTempDir);
                } else {
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.myTempDir);){
                        for (Path file2 : directoryStream) {
                            if (this.shouldKeepTmpFile(file2)) continue;
                            FileUtil.delete((Path)file2);
                        }
                    }
                    catch (NoSuchFileException noSuchFileException) {
                        // empty catch block
                    }
                }
            }
        }, () -> UsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS), () -> UsefulTestCase.clearFields((Object)this)).run((List)ObjectUtils.notNull(this.mySuppressedExceptions, Collections.emptyList()));
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull Path file2) {
        this.myPathsToKeep.add(file2.toAbsolutePath());
    }

    private boolean shouldKeepTmpFile(@NotNull Path file2) {
        for (Path pathToKeep : this.myPathsToKeep) {
            if (!file2.equals(pathToKeep)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupDeleteOnExitHookList() {
        ArrayList<String> list;
        Class<?> clazz = DELETE_ON_EXIT_HOOK_CLASS;
        synchronized (clazz) {
            if (DELETE_ON_EXIT_HOOK_DOT_FILES.isEmpty()) {
                return;
            }
            list = new ArrayList<String>(DELETE_ON_EXIT_HOOK_DOT_FILES);
        }
        for (int i2 = list.size() - 1; i2 >= 0; --i2) {
            String path = (String)list.get(i2);
            File file2 = new File(path);
            if (!file2.delete() && file2.exists()) continue;
            Class<?> clazz2 = DELETE_ON_EXIT_HOOK_CLASS;
            synchronized (clazz2) {
                DELETE_ON_EXIT_HOOK_DOT_FILES.remove(path);
                continue;
            }
        }
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Object manager2 = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map componentKeyStrokeMap = (Map)ReflectionUtil.getField(manager2.getClass(), (Object)manager2, Hashtable.class, (String)"componentKeyStrokeMap");
        componentKeyStrokeMap.clear();
        Map containerMap = (Map)ReflectionUtil.getField(manager2.getClass(), (Object)manager2, Hashtable.class, (String)"containerMap");
        containerMap.clear();
    }

    static void doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(() -> {
            try {
                UsefulTestCase.checkCodeInsightSettingsEqual(defaultSettings, settings);
            }
            catch (AssertionError error) {
                CodeInsightSettings clean2 = new CodeInsightSettings();
                for (Field field : clean2.getClass().getFields()) {
                    try {
                        ReflectionUtil.copyFieldValue((Object)clean2, (Object)settings, (Field)field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw error;
            }
        }).append(() -> {
            currentCodeStyleSettings.getIndentOptions(FileTypeManager.getInstance().getStdFileType("JAVA"));
            try {
                UsefulTestCase.checkCodeStyleSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }).run();
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        return this.myTestRootDisposable;
    }

    protected void runTest() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        Runnable runnable = () -> {
            try {
                TestLoggerFactory.onTestStarted();
                super.runTest();
                TestLoggerFactory.onTestFinished(true);
            }
            catch (InvocationTargetException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e.getTargetException();
            }
            catch (IllegalAccessException e) {
                TestLoggerFactory.onTestFinished(false);
                e.fillInStackTrace();
                throwables[0] = e;
            }
            catch (Throwable e) {
                TestLoggerFactory.onTestFinished(false);
                throwables[0] = e;
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected boolean shouldRunTest() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null && !policy.canRun(((Object)((Object)this)).getClass())) {
            return false;
        }
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (this.runInDispatchThread()) {
            Application app = ApplicationManager.getApplication();
            if (app == null) {
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeAndWait(runnable);
                }
            } else {
                app.invokeAndWait(runnable);
            }
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void defaultRunBare() throws Throwable {
        Throwable exception;
        block13: {
            exception = null;
            long setupStart = System.nanoTime();
            this.setUp();
            long setupCost = (System.nanoTime() - setupStart) / 1000000L;
            this.logPerClassCost(setupCost, TOTAL_SETUP_COST_MILLIS);
            this.runTest();
            try {
                long teardownStart = System.nanoTime();
                this.tearDown();
                long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
            }
            catch (Throwable tearingDown) {
                if (exception == null) {
                    exception = tearingDown;
                    break block13;
                }
                exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
            }
            break block13;
            catch (Throwable running) {
                try {
                    exception = running;
                }
                catch (Throwable throwable) {
                    try {
                        long teardownStart = System.nanoTime();
                        this.tearDown();
                        long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                        this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                    }
                    catch (Throwable tearingDown) {
                        exception = exception == null ? tearingDown : new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                    }
                    throw throwable;
                }
                try {
                    long teardownStart = System.nanoTime();
                    this.tearDown();
                    long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                    this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                }
                catch (Throwable tearingDown) {
                    if (exception == null) {
                        exception = tearingDown;
                        break block13;
                    }
                    exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void logPerClassCost(long cost, @NotNull Object2LongOpenHashMap<String> costMap) {
        costMap.addTo((Object)((Object)((Object)this)).getClass().getSuperclass().getName(), cost);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (Object2LongMap.Entry entry : TOTAL_SETUP_COST_MILLIS.object2LongEntrySet()) {
            System.out.printf("  %s: %d ms%n", entry.getKey(), entry.getLongValue());
            totalSetup += entry.getLongValue();
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (Object2LongMap.Entry entry : TOTAL_TEARDOWN_COST_MILLIS.object2LongEntrySet()) {
            System.out.printf("  %s: %d ms%n", entry.getKey(), entry.getLongValue());
            totalTeardown += entry.getLongValue();
        }
        System.out.printf("Total overhead: setup %d ms, teardown %d ms%n", totalSetup, totalTeardown);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']%n", totalSetup);
        System.out.printf("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']%n", totalTeardown);
    }

    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        if (this.runInDispatchThread()) {
            TestApplicationManagerKt.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)this::defaultRunBare));
        } else {
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            return policy.runInDispatchThread();
        }
        return true;
    }

    protected static void edt(@NotNull ThrowableRunnable<Throwable> runnable) {
        EdtTestUtil.runInEdtAndWait(runnable);
    }

    @NotNull
    public static String toString(@NotNull Iterable<?> collection) {
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder2 = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder2.append(new TreeSet((THashSet)o));
            } else {
                builder2.append(o);
            }
            builder2.append('\n');
        }
        return builder2.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(T @NotNull [] actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static void assertOrderedEquals(byte @NotNull [] actual, byte @NotNull [] expected) {
        UsefulTestCase.assertEquals((int)expected.length, (int)actual.length);
        for (int i2 = 0; i2 < actual.length; ++i2) {
            byte a = actual[i2];
            byte e = expected[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (byte)e, (byte)a);
        }
    }

    public static void assertOrderedEquals(int @NotNull [] actual, int @NotNull [] expected) {
        if (actual.length != expected.length) {
            UsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual)));
        }
        for (int i2 = 0; i2 < actual.length; ++i2) {
            int a = actual[i2];
            int e = expected[i2];
            UsefulTestCase.assertEquals((String)("not equals at index: " + i2), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, T ... expected) {
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals("", actual, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected) {
        UsefulTestCase.assertOrderedEquals(errorMsg, actual, expected, Objects::equals);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual, @NotNull Iterable<? extends T> expected, @NotNull BiPredicate<? super T, ? super T> predicate) {
        if (!UsefulTestCase.equals(actual, expected, predicate)) {
            String expectedString = UsefulTestCase.toString(expected);
            String actualString = UsefulTestCase.toString(actual);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    private static <T> boolean equals(@NotNull Iterable<? extends T> a1, @NotNull Iterable<? extends T> a2, @NotNull BiPredicate<? super T, ? super T> predicate) {
        Iterator<T> it1 = a1.iterator();
        Iterator<T> it2 = a2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (it1.hasNext() && it2.hasNext() && predicate.test(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(T @NotNull [] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(T @NotNull [] actual, T ... expected) {
        UsefulTestCase.assertSameElements(Arrays.asList(actual), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, T ... expected) {
        UsefulTestCase.assertSameElements(actual, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        UsefulTestCase.assertSameElements("", actual, expected);
    }

    public static <T> void assertSameElements(@NotNull String message, @NotNull Collection<? extends T> actual, @NotNull Collection<? extends T> expected) {
        if (actual.size() != expected.size() || !new HashSet<T>(expected).equals(new HashSet<T>(actual))) {
            Assert.assertEquals((String)message, new HashSet<T>(expected), new HashSet<T>(actual));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        PeekableIteratorWrapper expectedIt = new PeekableIteratorWrapper(expected.iterator());
        PeekableIteratorWrapper actualIt = new PeekableIteratorWrapper(collection.iterator());
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            Object actualElem;
            Object expectedElem = expectedIt.peek();
            if (expectedElem.equals(actualElem = actualIt.peek())) {
                expectedIt.next();
            }
            actualIt.next();
        }
        if (expectedIt.hasNext()) {
            throw new ComparisonFailure("", UsefulTestCase.toString(expected), UsefulTestCase.toString(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        UsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        ArrayList<T> copy2 = new ArrayList<T>(collection);
        copy2.retainAll(expected);
        UsefulTestCase.assertSameElements(UsefulTestCase.toString(collection), copy2, expected);
    }

    @NotNull
    public static String toString(Object @NotNull [] collection, @NotNull String separator) {
        return UsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        UsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> notExpected) {
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        UsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder builder2 = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder2.append(separator);
            }
            builder2.append(o);
            flag = true;
        }
        return builder2.toString();
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        int i2 = 0;
        for (T actual : collection) {
            try {
                checkers[i2].consume(actual);
            }
            catch (AssertionFailedError e) {
                System.out.println(i2 + ": " + actual);
                throw e;
            }
            ++i2;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(T @NotNull [] collection, Consumer<T> ... checkers) {
        UsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection.size() != checkers.length) {
            Assert.fail((String)UsefulTestCase.toString(collection));
        }
        Set checkerSet = ContainerUtil.set((Object[])checkers);
        int i2 = 0;
        Throwable lastError = null;
        for (T actual : collection) {
            boolean flag = true;
            for (Consumer condition : checkerSet) {
                Throwable error = UsefulTestCase.accepts(condition, actual);
                if (error == null) {
                    checkerSet.remove(condition);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i2 + "): " + actual));
            }
            ++i2;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<? super T> condition, T actual) {
        try {
            condition.consume(actual);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: " + null), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object t = o;
        return (T)t;
    }

    public static <T> T assertOneElement(@NotNull Collection<? extends T> collection) {
        Iterator<T> iterator2 = collection.iterator();
        String toString = UsefulTestCase.toString(collection);
        Assert.assertTrue((String)toString, (boolean)iterator2.hasNext());
        T t = iterator2.next();
        Assert.assertFalse((String)toString, (boolean)iterator2.hasNext());
        return t;
    }

    public static <T> T assertOneElement(T @NotNull [] ts) {
        Assert.assertEquals((String)Arrays.asList(ts).toString(), (long)1L, (long)ts.length);
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values) {
        for (T v : values) {
            if (!Objects.equals(value, v)) continue;
            return;
        }
        Assert.fail((String)(value + " should be equal to one of " + Arrays.toString(values)));
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
    }

    public static void assertEmpty(Object @NotNull [] array) {
        UsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        UsefulTestCase.assertNotNull(collection);
        UsefulTestCase.assertFalse((boolean)collection.isEmpty());
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        UsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        UsefulTestCase.assertEmpty("", collection);
    }

    public static void assertEmpty(String s) {
        UsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(@NotNull String errorMsg, @NotNull Collection<? extends T> collection) {
        UsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, Object @NotNull [] array) {
        if (array.length != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
        }
    }

    public static void assertSize(int expectedSize, @NotNull Collection<?> c) {
        if (c.size() != expectedSize) {
            UsefulTestCase.assertEquals((String)UsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
        }
    }

    @NotNull
    protected <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        Disposer.register((Disposable)this.getTestRootDisposable(), disposable);
        return disposable;
    }

    public static void assertSameLines(@NotNull String expected, @NotNull String actual) {
        UsefulTestCase.assertSameLines(null, expected, actual);
    }

    public static void assertSameLines(@Nullable String message, @NotNull String expected, @NotNull String actual) {
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual.trim());
        Assert.assertEquals((String)message, (Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file2) {
        UsefulTestCase.assertTrue((String)("File should exist " + file2), (boolean)file2.exists());
    }

    public static void assertDoesntExist(@NotNull File file2) {
        UsefulTestCase.assertFalse((String)("File should not exist " + file2), (boolean)file2.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        return UsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
    }

    @NotNull
    public static String getTestName(@Nullable String name, boolean lowercaseFirstLetter) {
        return name == null ? "" : PlatformTestUtil.getTestName(name, lowercaseFirstLetter);
    }

    @NotNull
    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        return testName.replaceAll("_.*", "");
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, @NotNull Supplier<String> messageProducer) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, true, messageProducer);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing) {
        UsefulTestCase.assertSameLinesWithFile(filePath, actualText, trimBeforeComparing, null);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing, @Nullable Supplier<String> messageProducer) {
        String fileText;
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData(filePath, actualText);
                System.out.println("File " + filePath + " created.");
            }
            fileText = FileUtil.loadFile((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData(filePath, actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? fileText.trim() : fileText));
        String actual = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? actualText.trim() : actualText));
        if (!Objects.equals(expected, actual)) {
            throw new FileComparisonFailure(messageProducer == null ? null : messageProducer.get(), expected, actual, filePath);
        }
    }

    protected static void clearFields(@NotNull Object test) throws IllegalAccessException {
        for (Class<?> aClass = test.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            UsefulTestCase.clearDeclaredFields(test, aClass);
        }
    }

    public static void clearDeclaredFields(@NotNull Object test, @NotNull Class<?> aClass) throws IllegalAccessException {
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test, null);
        }
    }

    private static void checkCodeStyleSettingsEqual(@NotNull CodeStyleSettings expected, @NotNull CodeStyleSettings settings) {
        if (!expected.equals((Object)settings)) {
            Element oldS = new Element("temp");
            expected.writeExternal(oldS);
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            String newString = JDOMUtil.writeElement((Element)newS);
            String oldString = JDOMUtil.writeElement((Element)oldS);
            Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
        }
    }

    private static void checkCodeInsightSettingsEqual(@NotNull CodeInsightSettings oldSettings, @NotNull CodeInsightSettings settings) {
        if (!oldSettings.equals((Object)settings)) {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement((Element)newS));
        }
    }

    public boolean isPerformanceTest() {
        String testName = this.getName();
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className);
    }

    public boolean isStressTest() {
        return UsefulTestCase.isStressTest(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean isStressTest(String testName, String className) {
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className) || UsefulTestCase.containsStressWords(testName) || UsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name) {
        return name != null && (name.contains("Stress") || name.contains("Slow"));
    }

    public static void doPostponedFormatting(@NotNull Project project2) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project2).doPostponedFormatting();
        });
    }

    protected void assertException(@NotNull AbstractExceptionCase<?> exceptionCase) {
        this.assertException(exceptionCase, null);
    }

    protected void assertException(@NotNull AbstractExceptionCase exceptionCase, @Nullable String expectedErrorMsg) {
        UsefulTestCase.assertExceptionOccurred(true, exceptionCase, expectedErrorMsg);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) {
        UsefulTestCase.assertThrows(exceptionClass, null, runnable);
    }

    public static <T extends Throwable> void assertThrows(final @NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsgPart, final @NotNull ThrowableRunnable<T> runnable) {
        UsefulTestCase.assertExceptionOccurred(true, new AbstractExceptionCase(){

            public Class<Throwable> getExpectedExceptionClass() {
                return exceptionClass;
            }

            @Override
            public void tryClosure() throws Throwable {
                runnable.run();
            }
        }, expectedErrorMsgPart);
    }

    protected <T extends Throwable> void assertNoException(@NotNull AbstractExceptionCase<T> exceptionCase) throws T {
        UsefulTestCase.assertExceptionOccurred(false, exceptionCase, null);
    }

    protected void assertNoThrowable(@NotNull Runnable closure) {
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        UsefulTestCase.assertNull(throwableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Throwable> void assertExceptionOccurred(boolean shouldOccur, @NotNull AbstractExceptionCase<T> exceptionCase, String expectedErrorMsgPart) throws T {
        block10: {
            boolean wasThrown = false;
            try {
                exceptionCase.tryClosure();
            }
            catch (Throwable e) {
                Throwable cause = e;
                while (cause instanceof LoggedErrorProcessor.TestLoggerAssertionError && cause.getCause() != null) {
                    cause = cause.getCause();
                }
                if (shouldOccur) {
                    wasThrown = true;
                    UsefulTestCase.assertInstanceOf(cause, exceptionCase.getExpectedExceptionClass());
                    if (expectedErrorMsgPart != null) {
                        UsefulTestCase.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains(expectedErrorMsgPart));
                    }
                    break block10;
                }
                if (exceptionCase.getExpectedExceptionClass().equals(cause.getClass())) {
                    wasThrown = true;
                    System.out.println();
                    e.printStackTrace(System.out);
                    UsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + cause.getMessage()));
                    break block10;
                }
                throw e;
            }
            finally {
                if (shouldOccur && !wasThrown) {
                    UsefulTestCase.fail((String)(exceptionCase.getExpectedExceptionClass().getName() + " must be thrown."));
                }
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        String methodName = "test" + this.getTestName(false);
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    @NotNull
    protected String getHomePath() {
        return PathManager.getHomePath().replace(File.separatorChar, '/');
    }

    public static void refreshRecursively(@NotNull VirtualFile file2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                file2.getChildren();
                return true;
            }
        });
        file2.refresh(false, true);
    }

    public static VirtualFile refreshAndFindFile(@NotNull File file2) {
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2));
    }

    public static void waitForAppLeakingThreads(long timeout, @NotNull TimeUnit timeUnit) {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            Application app = ApplicationManager.getApplication();
            if (app != null && !app.isDisposed()) {
                DocumentCommitThread commitThread;
                FileBasedIndex index = (FileBasedIndex)app.getServiceIfCreated(FileBasedIndex.class);
                if (index instanceof FileBasedIndexImpl) {
                    ((FileBasedIndexImpl)index).getChangedFilesCollector().waitForVfsEventsExecuted(timeout, timeUnit);
                }
                if ((commitThread = (DocumentCommitThread)app.getServiceIfCreated(DocumentCommitProcessor.class)) != null) {
                    commitThread.waitForAllCommits(timeout, timeUnit);
                }
            }
        }));
    }

    static {
        Class<?> aClass;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        ORIGINAL_TEMP_DIR = FileUtil.getTempDirectory();
        TOTAL_SETUP_COST_MILLIS = new Object2LongOpenHashMap();
        TOTAL_TEARDOWN_COST_MILLIS = new Object2LongOpenHashMap();
        LOG = Logger.getInstance(UsefulTestCase.class);
        defaultSettings = new CodeInsightSettings();
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
        Logger.setFactory(TestLoggerFactory.class);
        System.setProperty("apple.awt.UIElement", "true");
        try {
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            aClass = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set files = (Set)ReflectionUtil.getStaticFieldValue(aClass, Set.class, (String)"files");
        DELETE_ON_EXIT_HOOK_CLASS = aClass;
        DELETE_ON_EXIT_HOOK_DOT_FILES = files;
    }

    protected final class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName = UsefulTestCase.this.getTestName(false);
            return ((Object)((Object)UsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)testName) ? "" : ".test" + testName);
        }
    }
}

