/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchDialog;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class StructuralSearchAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        StructuralSearchAction.triggerAction(null, new SearchContext(event.getDataContext()), false);
    }

    public static void triggerAction(Configuration config, SearchContext searchContext, boolean replace) {
        Project project2 = searchContext.getProject();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        DialogWrapper dialog = StructuralSearchPlugin.getInstance(project2).getDialog();
        if (dialog != null) {
            assert (!dialog.isDisposed() && dialog.isVisible());
            JComponent component = dialog.getPreferredFocusedComponent();
            assert (component != null);
            IdeFocusManager.getInstance((Project)project2).requestFocus((Component)component, true);
            return;
        }
        StructuralSearchDialog searchDialog = new StructuralSearchDialog(searchContext, replace);
        if (config != null) {
            searchDialog.setUseLastConfiguration(true);
            searchDialog.loadConfiguration(config);
        }
        searchDialog.show();
    }

    public void update(@NotNull AnActionEvent event) {
        StructuralSearchPlugin plugin;
        Presentation presentation = event.getPresentation();
        Project project2 = event.getProject();
        StructuralSearchPlugin structuralSearchPlugin = plugin = project2 == null ? null : StructuralSearchPlugin.getInstance(project2);
        if (plugin == null || plugin.isSearchInProgress()) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
    }
}

