/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.inspection;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.ProblemDescriptorWithReporterName;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.DynamicGroupTool;
import com.intellij.codeInspection.ex.GlobalInspectionContextBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.dupLocator.iterators.CountingNodeIterator;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.structuralsearch.DefaultMatchResultSink;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchException;
import com.intellij.structuralsearch.impl.matcher.filters.LexicalNodesFilter;
import com.intellij.structuralsearch.impl.matcher.iterators.SsrFilteringNodeIterator;
import com.intellij.structuralsearch.inspection.SSBasedInspectionCompiledPatternsCache;
import com.intellij.structuralsearch.inspection.StructuralSearchInspectionToolWrapper;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.Replacer;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceConfiguration;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.ConfigurationManager;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import com.intellij.structuralsearch.plugin.util.DuplicateFilteringResultSink;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SSBasedInspection
extends LocalInspectionTool
implements DynamicGroupTool {
    static final Object LOCK = new Object();
    @NonNls
    public static final String SHORT_NAME = "SSBasedInspection";
    private final List<Configuration> myConfigurations = ContainerUtil.createLockFreeCopyOnWriteList();
    final Set<String> myProblemsReported = new HashSet<String>(1);
    private InspectionProfileImpl mySessionProfile = null;

    public void writeSettings(@NotNull Element node2) throws WriteExternalException {
        ConfigurationManager.writeConfigurations(node2, this.myConfigurations);
    }

    public void readSettings(@NotNull Element node2) throws InvalidDataException {
        this.myProblemsReported.clear();
        this.myConfigurations.clear();
        ConfigurationManager.readConfigurations(node2, this.myConfigurations);
    }

    @NotNull
    public String getGroupDisplayName() {
        return SSBasedInspection.getGeneralGroupName();
    }

    @NotNull
    @NonNls
    public String getShortName() {
        return SHORT_NAME;
    }

    public void initialize(@NotNull GlobalInspectionContext context2) {
        super.initialize(context2);
        this.mySessionProfile = ((GlobalInspectionContextBase)context2).getCurrentProfile();
    }

    public void cleanup(@NotNull Project project2) {
        super.cleanup(project2);
        this.mySessionProfile = null;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (this.myConfigurations.isEmpty()) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        Project project2 = holder.getProject();
        final InspectionProfileImpl profile = this.mySessionProfile != null ? this.mySessionProfile : InspectionProfileManager.getInstance((Project)project2).getCurrentProfile();
        for (Configuration configuration2 : this.myConfigurations) {
            SSBasedInspection.register(configuration2);
        }
        final Map<Configuration, Matcher> compiledOptions = SSBasedInspectionCompiledPatternsCache.getInstance(project2).getCompiledOptions(this.myConfigurations);
        if (compiledOptions.isEmpty()) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        PairProcessor processor2 = (matchResult, configuration) -> {
            PsiElement element = matchResult.getMatch();
            LocalQuickFix fix = SSBasedInspection.createQuickFix(project2, matchResult, configuration);
            Configuration mainConfiguration = this.getMainConfiguration((Configuration)configuration);
            String name = (String)ObjectUtils.notNull((Object)mainConfiguration.getProblemDescriptor(), (Object)mainConfiguration.getName());
            ProblemDescriptor descriptor = holder.getManager().createProblemDescriptor(element, name, fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
            holder.registerProblem((ProblemDescriptor)new ProblemDescriptorWithReporterName((ProblemDescriptorBase)descriptor, configuration.getUuid().toString()));
            return true;
        };
        for (Map.Entry<Configuration, Matcher> entry : compiledOptions.entrySet()) {
            Configuration configuration3 = entry.getKey();
            Matcher matcher = entry.getValue();
            if (matcher == null) continue;
            matcher.getMatchContext().setSink(new DuplicateFilteringResultSink(new InspectionResultSink((PairProcessor<? super MatchResult, ? super Configuration>)processor2, configuration3)));
        }
        return new PsiElementVisitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void visitElement(@NotNull PsiElement element) {
                if (LexicalNodesFilter.getInstance().accepts(element)) {
                    return;
                }
                Object object = LOCK;
                synchronized (object) {
                    SsrFilteringNodeIterator matchedNodes = new SsrFilteringNodeIterator(element);
                    for (Map.Entry entry : compiledOptions.entrySet()) {
                        block7: {
                            Configuration configuration = (Configuration)entry.getKey();
                            Matcher matcher = (Matcher)entry.getValue();
                            if (matcher == null || !matcher.checkIfShouldAttemptToMatch(matchedNodes) || !profile.isToolEnabled(HighlightDisplayKey.find((String)configuration.getUuid().toString()), element)) continue;
                            int nodeCount = matcher.getMatchContext().getPattern().getNodeCount();
                            try {
                                matcher.processMatchesInElement(new CountingNodeIterator(nodeCount, matchedNodes));
                            }
                            catch (StructuralSearchException e) {
                                if (!SSBasedInspection.this.myProblemsReported.add(configuration.getName())) break block7;
                                String message = e.getMessage().replace("a3cd264774bf4efb9ab609b250c5165c", "");
                                UIUtil.SSR_NOTIFICATION_GROUP.createNotification(NotificationType.ERROR).setContent(SSRBundle.message("inspection.script.problem", message, configuration.getName())).setImportant(true).notify(element.getProject());
                            }
                        }
                        matchedNodes.reset();
                    }
                }
            }
        };
    }

    public static void register(Configuration configuration) {
        if (configuration.getOrder() != 0) {
            return;
        }
        String shortName = configuration.getUuid().toString();
        HighlightDisplayKey key = HighlightDisplayKey.find((String)shortName);
        if (key != null) {
            if (!SSBasedInspection.isMetaDataChanged(configuration, key)) {
                return;
            }
            HighlightDisplayKey.unregister((String)shortName);
        }
        String suppressId = configuration.getSuppressId();
        String name = configuration.getName();
        if (suppressId == null) {
            HighlightDisplayKey.register((String)shortName, () -> name, (String)SHORT_NAME);
        } else {
            HighlightDisplayKey.register((String)shortName, () -> name, (String)suppressId, (String)SHORT_NAME);
        }
    }

    private static boolean isMetaDataChanged(Configuration configuration, HighlightDisplayKey key) {
        if (StringUtil.isEmpty((String)configuration.getSuppressId()) ? !SHORT_NAME.equals(key.getID()) : !configuration.getSuppressId().equals(key.getID())) {
            return true;
        }
        return !configuration.getName().equals(HighlightDisplayKey.getDisplayNameByKey((HighlightDisplayKey)key));
    }

    public List<LocalInspectionToolWrapper> getChildren() {
        return this.getConfigurations().stream().filter(configuration -> configuration.getOrder() == 0).map(configuration -> new StructuralSearchInspectionToolWrapper(this.getConfigurationsWithUuid(configuration.getUuid()))).collect(Collectors.toList());
    }

    static LocalQuickFix createQuickFix(Project project2, MatchResult matchResult, Configuration configuration) {
        if (!(configuration instanceof ReplaceConfiguration)) {
            return null;
        }
        ReplaceConfiguration replaceConfiguration = (ReplaceConfiguration)configuration;
        final Replacer replacer = new Replacer(project2, replaceConfiguration.getReplaceOptions());
        final ReplacementInfo replacementInfo = replacer.buildReplacement(matchResult);
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                return SSRBundle.message("SSRInspection.replace.with", replacementInfo.getReplacement());
            }

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                PsiElement element = descriptor.getPsiElement();
                if (element != null) {
                    replacer.replace(replacementInfo);
                }
            }

            @NotNull
            public String getFamilyName() {
                return SSRBundle.message("SSRInspection.family.name", new Object[0]);
            }
        };
    }

    private Configuration getMainConfiguration(Configuration configuration) {
        if (configuration.getOrder() == 0) {
            return configuration;
        }
        UUID uuid = configuration.getUuid();
        return this.myConfigurations.stream().filter(c -> c.getOrder() == 0 && uuid.equals(c.getUuid())).findFirst().orElse(configuration);
    }

    public List<Configuration> getConfigurations() {
        return Collections.unmodifiableList(this.myConfigurations);
    }

    public List<Configuration> getConfigurationsWithUuid(@NotNull UUID uuid) {
        List configurations = ContainerUtil.filter(this.myConfigurations, c -> uuid.equals(c.getUuid()));
        configurations.sort(Comparator.comparingInt(Configuration::getOrder));
        return configurations;
    }

    public boolean addConfiguration(@NotNull Configuration configuration) {
        if (this.myConfigurations.contains(configuration)) {
            return false;
        }
        this.myConfigurations.add(configuration);
        return true;
    }

    public boolean addConfigurations(@NotNull Collection<? extends Configuration> configurations) {
        boolean changed = false;
        for (Configuration configuration : configurations) {
            changed |= this.addConfiguration(configuration);
        }
        return changed;
    }

    public boolean removeConfiguration(@NotNull Configuration configuration) {
        return this.myConfigurations.remove(configuration);
    }

    public boolean removeConfigurationsWithUuid(@NotNull UUID uuid) {
        return this.myConfigurations.removeIf(c -> c.getUuid().equals(uuid));
    }

    private static class InspectionResultSink
    extends DefaultMatchResultSink {
        private final Configuration myConfiguration;
        private PairProcessor<? super MatchResult, ? super Configuration> myProcessor;

        InspectionResultSink(PairProcessor<? super MatchResult, ? super Configuration> processor2, Configuration configuration) {
            this.myProcessor = processor2;
            this.myConfiguration = configuration;
        }

        @Override
        public void newMatch(MatchResult result2) {
            this.myProcessor.process((Object)result2, (Object)this.myConfiguration);
        }

        @Override
        public void matchingFinished() {
            this.myProcessor = null;
        }
    }
}

