/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.impl.matcher.CompiledPattern;
import com.intellij.structuralsearch.impl.matcher.GlobalMatchingVisitor;
import com.intellij.structuralsearch.impl.matcher.MatchResultImpl;
import com.intellij.structuralsearch.plugin.util.SmartPsiPointer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class MatchContext {
    private final Stack<MatchedElementsListener> myMatchedElementsListenerStack = new Stack(2);
    private MatchResultSink sink;
    private final Stack<MatchResultImpl> previousResults = new Stack();
    private MatchResultImpl result;
    private CompiledPattern pattern;
    private MatchOptions options;
    private GlobalMatchingVisitor matcher;
    private boolean shouldRecursivelyMatch = true;
    private final Stack<List<PsiElement>> mySavedMatchedNodes = new Stack();
    private List<PsiElement> myMatchedNodes = new SmartList();

    public void addMatchedNode(PsiElement node2) {
        this.myMatchedNodes.add(node2);
    }

    public void removeMatchedNode(PsiElement node2) {
        this.myMatchedNodes.remove(node2);
    }

    public void saveMatchedNodes() {
        this.mySavedMatchedNodes.push(this.myMatchedNodes);
        this.myMatchedNodes = new SmartList();
    }

    public void restoreMatchedNodes() {
        this.myMatchedNodes = (List)this.mySavedMatchedNodes.tryPop();
    }

    public void clearMatchedNodes() {
        this.myMatchedNodes.clear();
    }

    public void setMatcher(GlobalMatchingVisitor matcher) {
        this.matcher = matcher;
    }

    public GlobalMatchingVisitor getMatcher() {
        return this.matcher;
    }

    public MatchOptions getOptions() {
        return this.options;
    }

    public void setOptions(MatchOptions options2) {
        this.options = options2;
    }

    public MatchResultImpl getPreviousResult() {
        if (this.previousResults.isEmpty()) {
            return null;
        }
        int index = this.previousResults.size() - 1;
        MatchResultImpl result2 = (MatchResultImpl)this.previousResults.get(index);
        while (result2 == null && index > 0) {
            result2 = (MatchResultImpl)this.previousResults.get(--index);
        }
        return result2;
    }

    public MatchResultImpl getResult() {
        if (this.result == null) {
            this.result = new MatchResultImpl();
        }
        return this.result;
    }

    public void pushResult() {
        this.previousResults.push((Object)this.result);
        this.result = null;
    }

    public void popResult() {
        this.result = (MatchResultImpl)this.previousResults.pop();
    }

    public void setResult(MatchResultImpl result2) {
        this.result = result2;
        if (result2 == null) {
            this.pattern.clearHandlersState();
        }
    }

    public boolean hasResult() {
        return this.result != null;
    }

    public CompiledPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(CompiledPattern pattern) {
        this.pattern = pattern;
    }

    public MatchResultSink getSink() {
        return this.sink;
    }

    public void setSink(MatchResultSink sink) {
        this.sink = sink;
    }

    public void clear() {
        this.result = null;
    }

    public boolean shouldRecursivelyMatch() {
        return this.shouldRecursivelyMatch;
    }

    public void setShouldRecursivelyMatch(boolean shouldRecursivelyMatch) {
        this.shouldRecursivelyMatch = shouldRecursivelyMatch;
    }

    public void pushMatchedElementsListener(MatchedElementsListener matchedElementsListener) {
        this.myMatchedElementsListenerStack.push((Object)matchedElementsListener);
    }

    public void popMatchedElementsListener() {
        this.myMatchedElementsListenerStack.pop();
    }

    public void notifyMatchedElements(Collection<PsiElement> matchedElements) {
        if (!this.myMatchedElementsListenerStack.isEmpty()) {
            ((MatchedElementsListener)this.myMatchedElementsListenerStack.peek()).matchedElements(matchedElements);
        }
    }

    public void dispatchMatched() {
        if (this.myMatchedNodes.isEmpty()) {
            return;
        }
        MatchResultImpl result2 = this.getResult();
        if (this.doDispatch(result2)) {
            return;
        }
        MatchContext.processNoSubstitutionMatch(this.myMatchedNodes, result2);
        this.getSink().newMatch(result2);
    }

    private boolean doDispatch(MatchResult result2) {
        boolean ret = false;
        for (MatchResult r : result2.getChildren()) {
            if (r.isScopeMatch() && !r.isTarget() || r.isMultipleMatch()) {
                ret |= this.doDispatch(r);
                continue;
            }
            if (!r.isTarget()) continue;
            this.getSink().newMatch(r);
            ret = true;
        }
        return ret;
    }

    private static void processNoSubstitutionMatch(List<PsiElement> matchedNodes, MatchResultImpl result2) {
        boolean complexMatch = matchedNodes.size() > 1;
        PsiElement match = matchedNodes.get(0);
        if (!complexMatch) {
            result2.setMatchRef(new SmartPsiPointer(match));
            result2.setMatchImage(match.getText());
        } else {
            for (PsiElement matchStatement : matchedNodes) {
                result2.addChild(new MatchResultImpl("__line__", matchStatement.getText(), new SmartPsiPointer(matchStatement), false));
            }
            result2.setMatchRef(new SmartPsiPointer(match));
            result2.setMatchImage(match.getText());
            result2.setName("__multi_line__");
        }
    }

    @FunctionalInterface
    public static interface MatchedElementsListener {
        public void matchedElements(@NotNull Collection<PsiElement> var1);
    }
}

