/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.dupLocator.iterators.ArrayBackedNodeIterator;
import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.handlers.MatchingHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SimpleHandler;
import com.intellij.structuralsearch.impl.matcher.handlers.SubstitutionHandler;
import com.intellij.structuralsearch.impl.matcher.strategies.MatchingStrategy;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class CompiledPattern {
    public static final Key<Object> HANDLER_KEY = Key.create((String)"ss.handler");
    private final Map<Object, MatchingHandler> handlers = new THashMap();
    private final MultiMap<String, PsiElement> variableNodes = new MultiMap();
    private SearchScope scope;
    private NodeIterator nodes;
    private MatchingStrategy strategy;
    private PsiElement targetNode;
    private int nodeCount;
    private PsiElement last;
    private MatchingHandler lastHandler;

    public abstract String @NotNull [] getTypedVarPrefixes();

    public abstract boolean isTypedVar(@NotNull String var1);

    public void setTargetNode(PsiElement element) {
        this.targetNode = element;
    }

    public PsiElement getTargetNode() {
        return this.targetNode;
    }

    public MatchingStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(MatchingStrategy strategy2) {
        this.strategy = strategy2;
    }

    public int getNodeCount() {
        return this.nodeCount;
    }

    public NodeIterator getNodes() {
        return this.nodes;
    }

    public void setNodes(@NotNull List<? extends PsiElement> elements) {
        this.nodes = new ArrayBackedNodeIterator(PsiUtilCore.toPsiElementArray(elements));
        this.nodeCount = elements.size();
    }

    @Contract(value="null -> false")
    public boolean isTypedVar(PsiElement element) {
        return element != null && this.isTypedVar(element.getText());
    }

    public boolean isRealTypedVar(PsiElement element) {
        if (element == null || element.getTextLength() <= 0) {
            return false;
        }
        String str = this.getTypedVarString(element);
        return !str.isEmpty() && this.isTypedVar(str);
    }

    @NotNull
    public String getTypedVarString(@NotNull PsiElement element) {
        StructuralSearchProfile profile = StructuralSearchUtil.getProfileByPsiElement(element);
        String typedVarString = profile == null ? element.getText() : profile.getTypedVarString(element);
        return typedVarString.trim();
    }

    public MatchingHandler getHandlerSimple(@NotNull PsiElement node2) {
        return this.handlers.get(node2);
    }

    @NotNull
    public MatchingHandler getHandler(@NotNull PsiElement node2) {
        if (node2 == this.last) {
            return this.lastHandler;
        }
        MatchingHandler handler = this.handlers.get(node2);
        if (handler == null) {
            handler = new SimpleHandler();
            this.setHandler(node2, handler);
        }
        this.last = node2;
        this.lastHandler = handler;
        return handler;
    }

    public MatchingHandler getHandler(String name) {
        return this.handlers.get(name);
    }

    public void setHandler(PsiElement node2, MatchingHandler handler) {
        this.last = null;
        this.handlers.put(node2, handler);
    }

    @NotNull
    public SubstitutionHandler createSubstitutionHandler(@NotNull String name, @NotNull String compiledName, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        SubstitutionHandler handler = (SubstitutionHandler)this.handlers.get(compiledName);
        if (handler != null) {
            return handler;
        }
        handler = this.doCreateSubstitutionHandler(name, target, minOccurs, maxOccurs, greedy);
        this.handlers.put(compiledName, handler);
        return handler;
    }

    @NotNull
    protected SubstitutionHandler doCreateSubstitutionHandler(@NotNull String name, boolean target, int minOccurs, int maxOccurs, boolean greedy) {
        return new SubstitutionHandler(name, target, minOccurs, maxOccurs, greedy);
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public void clearHandlers() {
        this.handlers.clear();
        this.last = null;
        this.lastHandler = null;
    }

    void clearHandlersState() {
        for (MatchingHandler h : this.handlers.values()) {
            if (h == null) continue;
            h.reset();
        }
    }

    public boolean isToResetHandler(@NotNull PsiElement element) {
        return true;
    }

    @NotNull
    public List<PsiElement> getVariableNodes(@NotNull String name) {
        Collection elements = this.variableNodes.get((Object)name);
        return elements instanceof List ? (List)elements : new SmartList(elements);
    }

    public void putVariableNode(@NotNull String name, @NotNull PsiElement node2) {
        this.variableNodes.putValue((Object)name, (Object)node2);
    }
}

