/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.project;

import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.impl.DummyProject;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.project.impl.ProjectExImpl;
import com.intellij.openapi.project.impl.ProjectImpl;
import com.intellij.openapi.project.impl.ProjectManagerExImpl;
import com.intellij.openapi.project.impl.TooManyProjectLeakedException;
import com.intellij.project.TestProjectManagerKt;
import com.intellij.util.containers.UnsafeWeakList;
import com.intellij.util.ref.GCUtil;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0014J\b\u0010\u0017\u001a\u00020\nH\u0002J\u0010\u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020 H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u00072\u0006\u0010&\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010'\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0007H\u0016J\u0006\u0010(\u001a\u00020)J\u0015\u0010*\u001a\u00020\u00112\u000b\u0010\u0013\u001a\u00070\u0007\u00a2\u0006\u0002\b+H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/project/TestProjectManager;", "Lcom/intellij/openapi/project/impl/ProjectManagerExImpl;", "()V", "isTracking", "", "projects", "Ljava/util/WeakHashMap;", "Lcom/intellij/openapi/project/Project;", "", "<set-?>", "", "totalCreatedProjectCount", "getTotalCreatedProjectCount", "()I", "trackingProjects", "Lcom/intellij/util/containers/UnsafeWeakList;", "checkProjectLeaksInTests", "", "closeProject", "project", "saveProject", "dispose", "checkCanClose", "getLeakedProjectCount", "getLeakedProjects", "Lkotlin/sequences/Sequence;", "handleErrorOnNewProject", "t", "", "instantiateProject", "Lcom/intellij/openapi/project/impl/ProjectImpl;", "projectStoreBaseDir", "Ljava/nio/file/Path;", "options", "Lcom/intellij/ide/impl/OpenProjectTask;", "loadProject", "file", "newProject", "projectFile", "openProject", "startTracking", "Lcom/intellij/openapi/application/AccessToken;", "trackProject", "Lorg/jetbrains/annotations/NotNull;", "Companion", "intellij.platform.testFramework"})
@ApiStatus.Internal
public final class TestProjectManager
extends ProjectManagerExImpl {
    private int totalCreatedProjectCount;
    private final WeakHashMap<Project, String> projects = new WeakHashMap();
    private volatile boolean isTracking;
    private final UnsafeWeakList<Project> trackingProjects = new UnsafeWeakList();
    public static final Companion Companion = new Companion(null);

    public final int getTotalCreatedProjectCount() {
        return this.totalCreatedProjectCount;
    }

    @Nullable
    public Project newProject(@NotNull Path projectFile, @NotNull OpenProjectTask options2) {
        int n = this.totalCreatedProjectCount;
        this.totalCreatedProjectCount = n + 1;
        this.checkProjectLeaksInTests();
        Project project2 = super.newProject(projectFile, options2);
        if (project2 != null && TestProjectManagerKt.access$getLOG_PROJECT_LEAKAGE$p()) {
            this.projects.put(project2, null);
        }
        return project2;
    }

    protected void handleErrorOnNewProject(@NotNull Throwable t) {
        throw t;
    }

    public boolean openProject(@NotNull Project project2) {
        if (project2 instanceof ProjectExImpl && ((ProjectExImpl)project2).isLight()) {
            ((ProjectExImpl)project2).setTemporarilyDisposed(false);
            boolean isInitialized = StartupManagerEx.getInstanceEx((Project)project2).startupActivityPassed();
            if (isInitialized) {
                this.addToOpened(project2);
                return true;
            }
        }
        return super.openProject(project2);
    }

    @NotNull
    public Project loadProject(@NotNull Path file2) {
        Project project2 = super.loadProject(file2);
        this.trackProject(project2);
        return project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void trackProject(Project project2) {
        if (this.isTracking) {
            TestProjectManager testProjectManager = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (testProjectManager) {
                boolean bl3 = false;
                if (this.isTracking) {
                    this.trackingProjects.add((Object)project2);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @NotNull
    protected ProjectImpl instantiateProject(@NotNull Path projectStoreBaseDir, @NotNull OpenProjectTask options2) {
        ProjectImpl project2 = super.instantiateProject(projectStoreBaseDir, options2);
        this.trackProject((Project)project2);
        return project2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean closeProject(@NotNull Project project2, boolean saveProject, boolean dispose2, boolean checkCanClose) {
        if (this.isTracking) {
            TestProjectManager testProjectManager = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (testProjectManager) {
                boolean bl3 = false;
                if (this.isTracking) {
                    this.trackingProjects.remove((Object)project2);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        boolean result2 = super.closeProject(project2, saveProject, dispose2, checkCanClose);
        UndoManager undoManager = UndoManager.getGlobalInstance();
        if (undoManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.command.impl.UndoManagerImpl");
        }
        UndoManagerImpl undoManager2 = (UndoManagerImpl)undoManager;
        if (!undoManager2.isInsideCommand()) {
            undoManager2.dropHistoryInTests();
        }
        return result2;
    }

    @NotNull
    public final synchronized AccessToken startTracking() {
        if (this.isTracking) {
            throw (Throwable)new IllegalStateException("Tracking is already started");
        }
        return new AccessToken(this){
            final /* synthetic */ TestProjectManager this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finish() {
                TestProjectManager testProjectManager = this.this$0;
                boolean bl = false;
                boolean bl2 = false;
                synchronized (testProjectManager) {
                    boolean bl3 = false;
                    TestProjectManager.access$setTracking$p(this.this$0, false);
                    StringBuilder error = null;
                    for (Project project2 : TestProjectManager.access$getTrackingProjects$p(this.this$0)) {
                        if (error == null) {
                            error = new StringBuilder();
                        }
                        error.append(project2.toString());
                        error.append("\nCreation trace: ");
                        Project project3 = project2;
                        if (project3 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.project.ex.ProjectEx");
                        }
                        error.append(((ProjectEx)project3).getCreationTrace());
                    }
                    TestProjectManager.access$getTrackingProjects$p(this.this$0).clear();
                    if (error != null) {
                        throw (Throwable)new IllegalStateException(error.toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            {
                this.this$0 = this$0;
            }
        };
    }

    private final int getLeakedProjectCount() {
        return SequencesKt.count(this.getLeakedProjects());
    }

    private final Sequence<Project> getLeakedProjects() {
        this.projects.remove(DummyProject.getInstance());
        return CollectionsKt.asSequence((Iterable)this.projects.keySet());
    }

    private final void checkProjectLeaksInTests() {
        if (!TestProjectManagerKt.access$getLOG_PROJECT_LEAKAGE$p() || this.getLeakedProjectCount() < 5) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - TestProjectManagerKt.access$getCHECK_START$p() < TestProjectManagerKt.access$getLEAK_CHECK_INTERVAL$p()) {
            return;
        }
        for (int i2 = 0; i2 < 3 && this.getLeakedProjectCount() >= 5; ++i2) {
            GCUtil.tryGcSoftlyReachableObjects();
        }
        TestProjectManagerKt.access$setCHECK_START$p(currentTime);
        if (this.getLeakedProjectCount() >= 5) {
            System.gc();
            UnsafeWeakList copy2 = (UnsafeWeakList)SequencesKt.toCollection(this.getLeakedProjects(), (Collection)((Collection)new UnsafeWeakList()));
            this.projects.clear();
            if (SequencesKt.count((Sequence)SequencesKt.asSequence((Iterator)copy2.iterator())) >= 5) {
                throw (Throwable)new TooManyProjectLeakedException((Iterable)copy2);
            }
        }
    }

    public static final /* synthetic */ boolean access$isTracking$p(TestProjectManager $this) {
        return $this.isTracking;
    }

    public static final /* synthetic */ void access$setTracking$p(TestProjectManager $this, boolean bl) {
        $this.isTracking = bl;
    }

    public static final /* synthetic */ UnsafeWeakList access$getTrackingProjects$p(TestProjectManager $this) {
        return $this.trackingProjects;
    }

    public static final /* synthetic */ int access$getTotalCreatedProjectCount$p(TestProjectManager $this) {
        return $this.totalCreatedProjectCount;
    }

    public static final /* synthetic */ void access$setTotalCreatedProjectCount$p(TestProjectManager $this, int n) {
        $this.totalCreatedProjectCount = n;
    }

    @JvmStatic
    @Nullable
    public static final TestProjectManager getInstanceExIfCreated() {
        return Companion.getInstanceExIfCreated();
    }

    @JvmStatic
    @NotNull
    public static final String getCreationPlace(@NotNull Project project2) {
        return Companion.getCreationPlace(project2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\n\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007J\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/project/TestProjectManager$Companion;", "", "()V", "getCreationPlace", "", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceExIfCreated", "Lcom/intellij/project/TestProjectManager;", "getTotalCreatedProjectCount", "", "intellij.platform.testFramework"})
    public static final class Companion {
        @JvmStatic
        @Nullable
        public final TestProjectManager getInstanceExIfCreated() {
            return (TestProjectManager)ProjectManager.getInstanceIfCreated();
        }

        public final int getTotalCreatedProjectCount() {
            Application application = ApplicationManager.getApplication();
            TestProjectManager testProjectManager = (TestProjectManager)(application != null ? (ProjectManager)application.getServiceIfCreated(ProjectManager.class) : null);
            return testProjectManager != null ? testProjectManager.getTotalCreatedProjectCount() : 0;
        }

        @JvmStatic
        @NotNull
        public final String getCreationPlace(@NotNull Project project2) {
            StringBuilder stringBuilder = new StringBuilder().append(project2).append(' ');
            String string = project2 instanceof ProjectEx ? ((ProjectEx)project2).getCreationTrace() : null;
            if (string == null) {
                string = "";
            }
            return stringBuilder.append(string).toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

