/*
 * Decompiled with CFR 0.152.
 */
import com.intellij.TestAll;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.Timings;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;

public class _FirstInSuiteTest
extends TestCase {
    private static long suiteStarted;
    private static boolean nothingIsCalled;

    static long getSuiteStartTime() {
        return suiteStarted;
    }

    public void testReportClassLoadingProblems() {
        List<Throwable> problems = TestAll.getLoadingClassProblems();
        if (problems.isEmpty()) {
            return;
        }
        StringBuilder builder2 = new StringBuilder("The following test classes were not loaded:\n");
        for (Throwable each : problems) {
            builder2.append(each).append("\n");
            each.printStackTrace(System.out);
        }
        throw new AssertionError((Object)builder2.toString());
    }

    public void testNothing() throws Exception {
        if (nothingIsCalled) {
            return;
        }
        nothingIsCalled = true;
        suiteStarted = System.nanoTime();
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
        SwingUtilities.invokeAndWait(() -> System.out.println("EDT is " + Thread.currentThread()));
        TestRunnerUtil.replaceIdeEventQueueSafely();
        SwingUtilities.invokeAndWait(() -> System.out.println("EDT is " + Thread.currentThread()));
        Class.forName("com.sun.jna.Native");
        String tempDirectory = FileUtilRt.getTempDirectory();
        String[] list = new File(tempDirectory).list();
        assert (list != null);
        System.out.println("FileUtil.getTempDirectory() = " + tempDirectory + " (" + list.length + " files)");
        Preferences.userRoot();
    }

    public void testNothingPerformance() throws Exception {
        System.out.println(Timings.getStatistics());
        this.testNothing();
    }

    public void testFileEncoding() {
        _FirstInSuiteTest.assertEncoding("file.encoding");
        _FirstInSuiteTest.assertEncoding("sun.jnu.encoding");
    }

    private static void assertEncoding(@NotNull String property) {
        String encoding = System.getProperty(property);
        System.out.println("** " + property + "=" + encoding);
        _FirstInSuiteTest.assertNotNull((String)("The property '" + property + "' is 'null'. Please check build configuration settings."), (Object)encoding);
        _FirstInSuiteTest.assertFalse((String)("The property '" + property + "' is set to a default value. Please make sure the build agent has sane locale settings."), (boolean)Charset.forName(encoding).aliases().contains("default"));
    }
}

