/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLScalarList;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.impl.YAMLBlockScalarImpl;

public class YAMLScalarListImpl
extends YAMLBlockScalarImpl
implements YAMLScalarList {
    public YAMLScalarListImpl(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    @NotNull
    protected IElementType getContentType() {
        return YAMLTokenTypes.SCALAR_LIST;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
        return "\n";
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        int indent = this.locateIndent();
        if (indent == 0) {
            indent = YAMLUtil.getIndentToThisElement((PsiElement)this) + 2;
        }
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) != '\n') continue;
            result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n" + indentString)));
        }
        return result;
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text) {
        String original = this.getNode().getText();
        int commonPrefixLength = StringUtil.commonPrefixLength((CharSequence)original, (CharSequence)text);
        int commonSuffixLength = StringUtil.commonSuffixLength((CharSequence)original, (CharSequence)text);
        int indent = this.locateIndent();
        ASTNode scalarEol = this.getNode().findChildByType((IElementType)YAMLTokenTypes.SCALAR_EOL);
        if (scalarEol == null) {
            return super.updateText(text);
        }
        int eolOffsetInParent = scalarEol.getStartOffsetInParent();
        int startContent = eolOffsetInParent + indent + 1;
        if (startContent >= commonPrefixLength) {
            return super.updateText(text);
        }
        String originalRowPrefix = original.substring(startContent, commonPrefixLength);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        String prefix = originalRowPrefix.replaceAll("\n" + indentString, "\n");
        String suffix = text.substring(text.length() - commonSuffixLength).replaceAll("\n" + indentString, "\n");
        String result = prefix + text.substring(commonPrefixLength, text.length() - commonSuffixLength) + suffix;
        return super.updateText(result);
    }

    @Override
    public String toString() {
        return "YAML scalar list";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor instanceof YamlPsiElementVisitor) {
            ((YamlPsiElementVisitor)visitor).visitScalarList(this);
        } else {
            super.accept(visitor);
        }
    }
}

