/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLMappingImpl;

public class YAMLBlockMappingImpl
extends YAMLMappingImpl {
    public static final String EMPTY_MAP_MESSAGE = "YAML map without any key-value";

    public YAMLBlockMappingImpl(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public YAMLKeyValue getFirstKeyValue() {
        YAMLKeyValue firstKeyValue = (YAMLKeyValue)this.findChildByType(YAMLElementTypes.KEY_VALUE_PAIR);
        if (firstKeyValue == null) {
            throw new IllegalStateException(EMPTY_MAP_MESSAGE);
        }
        return firstKeyValue;
    }

    private void addNewKeyToTheEnd(@NotNull YAMLKeyValue key) {
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance(this.getProject());
        IElementType lastChildType = PsiUtilCore.getElementType((PsiElement)this.getLastChild());
        if (indent == 0) {
            if (lastChildType != YAMLTokenTypes.EOL) {
                this.add(generator.createEol());
            }
        } else if (lastChildType != YAMLTokenTypes.INDENT || this.getLastChild().getTextLength() != indent) {
            this.add(generator.createEol());
            this.add(generator.createIndent(indent));
        }
        this.add((PsiElement)key);
    }

    @Override
    protected void addNewKey(@NotNull YAMLKeyValue key) {
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        ASTNode node = this.getNode();
        ASTNode whereInsert = null;
        for (ASTNode place = node.getLastChildNode(); place != null; place = place.getTreePrev()) {
            if (place.getElementType() == YAMLTokenTypes.INDENT && place.getTextLength() == indent) {
                whereInsert = place;
                continue;
            }
            if (place.getElementType() != YAMLTokenTypes.EOL) break;
            ASTNode next = place.getTreeNext();
            if (next != null && next.getElementType() != YAMLTokenTypes.EOL) continue;
            whereInsert = place;
        }
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance(this.getProject());
        if (whereInsert == null) {
            this.add(generator.createEol());
            this.add(generator.createIndent(indent));
            this.add((PsiElement)key);
            return;
        }
        PsiElement anchor = whereInsert.getPsi();
        if (indent == 0 || whereInsert.getElementType() == YAMLTokenTypes.INDENT && this.getLastChild().getTextLength() == indent) {
            this.addAfter((PsiElement)key, anchor);
            return;
        }
        if (whereInsert.getElementType() != YAMLTokenTypes.EOL) {
            anchor = this.addAfter(generator.createEol(), anchor);
        }
        this.addAfter(generator.createIndent(indent), anchor);
        this.addAfter((PsiElement)key, anchor);
    }

    public void insertKeyValueAtOffset(@NotNull YAMLKeyValue keyValue, int offset) {
        PsiElement child;
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        if (offset < this.getTextRange().getStartOffset()) {
            offset = this.getTextRange().getStartOffset();
        }
        YAMLElementGenerator generator = YAMLElementGenerator.getInstance(this.getProject());
        if (offset == this.getTextRange().getStartOffset()) {
            boolean pasteAtEmptyFirstMappingLine = PsiUtilCore.getElementType((PsiElement)this.getPrevSibling()) == YAMLTokenTypes.INDENT && PsiUtilCore.getElementType((PsiElement)this.getFirstChild()) == YAMLTokenTypes.EOL;
            PsiElement newElement = this.addBefore((PsiElement)keyValue, this.getFirstChild());
            if (!pasteAtEmptyFirstMappingLine) {
                newElement = this.addAfter(generator.createEol(), newElement);
                this.addAfter(generator.createIndent(indent), newElement);
            }
            return;
        }
        if (offset == this.getTextRange().getEndOffset()) {
            this.addNewKeyToTheEnd(keyValue);
            return;
        }
        if (offset > this.getTextRange().getEndOffset()) {
            PsiElement nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)this);
            SmartList toBeRemoved = new SmartList();
            while (YAMLElementTypes.SPACE_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)nextLeaf))) {
                if (offset >= nextLeaf.getTextRange().getStartOffset()) {
                    toBeRemoved.add(nextLeaf);
                }
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            }
            for (PsiElement leaf : toBeRemoved) {
                this.add(leaf);
            }
            for (PsiElement leaf : toBeRemoved) {
                leaf.delete();
            }
            this.addNewKeyToTheEnd(keyValue);
            return;
        }
        for (child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) == YAMLTokenTypes.INDENT && offset <= child.getTextRange().getEndOffset()) {
                if (PsiUtilCore.getElementType((PsiElement)child.getNextSibling()) == YAMLTokenTypes.EOL) {
                    this.addAfter((PsiElement)keyValue, child);
                    return;
                }
                PsiElement newElement = this.addBefore(generator.createIndent(indent), child);
                newElement = this.addAfter((PsiElement)keyValue, newElement);
                this.addAfter(generator.createEol(), newElement);
                return;
            }
            if (offset <= child.getTextRange().getEndOffset()) break;
        }
        while (child != null) {
            if (PsiUtilCore.getElementType((PsiElement)child) == YAMLTokenTypes.EOL) {
                PsiElement element = child;
                if (indent != 0) {
                    element = this.addAfter(generator.createIndent(indent), element);
                }
                element = this.addAfter((PsiElement)keyValue, element);
                if (PsiUtilCore.getElementType((PsiElement)child) != YAMLTokenTypes.EOL) {
                    this.addAfter(generator.createEol(), element);
                }
                return;
            }
            child = child.getNextSibling();
        }
        this.addNewKeyToTheEnd(keyValue);
    }

    @Nullable
    public YAMLKeyValue getOrCreateKeySequence(@NotNull List<String> keyComponents, int preferableOffset) {
        if (keyComponents.isEmpty()) {
            return null;
        }
        String head = keyComponents.iterator().next();
        List tail = ContainerUtil.subList(keyComponents, (int)1);
        YAMLKeyValue keyValue = this.getKeyValueByKey(head);
        if (keyValue == null) {
            int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
            String text = YAMLElementGenerator.createChainedKey(keyComponents, indent);
            YAMLElementGenerator generator = YAMLElementGenerator.getInstance(this.getProject());
            Collection values = PsiTreeUtil.collectElementsOfType((PsiElement)generator.createDummyYamlWithText(text), (Class[])new Class[]{YAMLKeyValue.class});
            if (values.isEmpty()) {
                Logger.getInstance(YAMLBlockMappingImpl.class).error("No one key-value created: input sequence = " + keyComponents + " generated text = '" + text + "'");
                return null;
            }
            YAMLKeyValue newKeyValue = (YAMLKeyValue)values.iterator().next();
            this.insertKeyValueAtOffset(newKeyValue, preferableOffset);
            keyValue = this.getKeyValueByKey(head);
            assert (keyValue != null);
        }
        if (keyComponents.size() == 1) {
            return keyValue;
        }
        if (keyValue.getValue() instanceof YAMLBlockMappingImpl) {
            return ((YAMLBlockMappingImpl)keyValue.getValue()).getOrCreateKeySequence(tail, preferableOffset);
        }
        return null;
    }
}

