/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.meta.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.meta.impl.YamlDebugUtil;
import org.jetbrains.yaml.meta.model.Field;
import org.jetbrains.yaml.meta.model.ModelAccess;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLSequenceItem;
import org.jetbrains.yaml.psi.YAMLValue;

@ApiStatus.Internal
public class YamlMetaTypeProvider {
    private static final Logger LOG = Logger.getInstance(YamlMetaTypeProvider.class);
    private final Key<CachedValue<FieldAndRelation>> myKey;
    @NotNull
    private final ModelAccess myMetaModel;
    @NotNull
    private final ModificationTracker myModificationTracker;

    public YamlMetaTypeProvider(@NotNull ModelAccess metaModel, @NotNull ModificationTracker modificationTracker) {
        this.myMetaModel = metaModel;
        this.myKey = Key.create((String)(metaModel.getClass().getName() + ":KEY"));
        this.myModificationTracker = modificationTracker;
    }

    @Nullable
    public MetaTypeProxy getMetaTypeProxy(@NotNull PsiElement psi) {
        if (psi instanceof YAMLValue) {
            return this.getValueMetaType((YAMLValue)psi);
        }
        YAMLValue metaOwner = this.getMetaOwner(psi);
        return metaOwner == null ? null : this.getValueMetaType(metaOwner);
    }

    @Nullable
    public YAMLValue getMetaOwner(@NotNull PsiElement psi) {
        PsiFile file = psi.getContainingFile();
        if (!(file instanceof YAMLFile)) {
            return null;
        }
        return YamlMetaTypeProvider.getTypedAncestorOrSelf(psi, YAMLValue.class);
    }

    @Nullable
    public MetaTypeProxy getKeyValueMetaType(@NotNull YAMLKeyValue keyValue) {
        if (keyValue.getValue() != null) {
            return this.getMetaTypeProxy((PsiElement)keyValue.getValue());
        }
        Field type = this.computeMetaType(keyValue);
        return FieldAndRelation.forNullable(type, Field.Relation.OBJECT_CONTENTS);
    }

    @Nullable
    public MetaTypeProxy getValueMetaType(@NotNull YAMLValue typedValue) {
        return (MetaTypeProxy)CachedValuesManager.getCachedValue((PsiElement)typedValue, this.myKey, () -> {
            YamlMetaTypeProvider.debug(" >> computing type for : " + YamlDebugUtil.getDebugInfo((PsiElement)typedValue));
            FieldAndRelation computed = this.computeMetaType(typedValue);
            YamlMetaTypeProvider.debug(" << finished for : " + YamlDebugUtil.getDebugInfo((PsiElement)typedValue) + ", result: " + (computed == null ? "<null>" : computed));
            return new CachedValueProvider.Result((Object)computed, new Object[]{typedValue.getContainingFile(), this.myModificationTracker});
        });
    }

    @Nullable
    private FieldAndRelation computeMetaType(@NotNull YAMLValue value) {
        PsiElement typed = PsiTreeUtil.getParentOfType((PsiElement)value, (Class[])new Class[]{YAMLKeyValue.class, YAMLSequenceItem.class, YAMLDocument.class});
        if (typed instanceof YAMLDocument) {
            Field root = this.myMetaModel.getRoot((YAMLDocument)typed);
            return FieldAndRelation.forNullable(root, Field.Relation.OBJECT_CONTENTS);
        }
        if (typed instanceof YAMLSequenceItem) {
            YAMLSequenceItem sequenceItem = (YAMLSequenceItem)typed;
            YAMLSequence sequence = (YAMLSequence)ObjectUtils.tryCast((Object)sequenceItem.getParent(), YAMLSequence.class);
            if (sequence == null) {
                YamlMetaTypeProvider.debug("Unexpected: sequenceItem parent is not a sequence: " + sequenceItem.getParent());
                return null;
            }
            FieldAndRelation sequenceMeta = (FieldAndRelation)this.getMetaTypeProxy((PsiElement)sequence);
            return sequenceMeta == null ? null : FieldAndRelation.forNullable(sequenceMeta.getField(), Field.Relation.SEQUENCE_ITEM);
        }
        if (typed instanceof YAMLKeyValue) {
            YAMLKeyValue keyValue = (YAMLKeyValue)typed;
            Field keyValueType = this.computeMetaType(keyValue);
            if (keyValueType == null) {
                return null;
            }
            Field.Relation relation = Field.Relation.OBJECT_CONTENTS;
            if (value instanceof YAMLScalar) {
                relation = YamlMetaTypeProvider.computeScalarValueRelation(keyValue, (YAMLScalar)value);
            } else if (value instanceof YAMLSequence) {
                relation = Field.Relation.SEQUENCE_ITEM;
            }
            return FieldAndRelation.forNullable(keyValueType, relation);
        }
        return null;
    }

    private static Field.Relation computeScalarValueRelation(@NotNull YAMLKeyValue keyValue, @NotNull YAMLScalar value) {
        YAMLScalar keySibling;
        YAMLScalar yAMLScalar = keySibling = value.getParent() instanceof YAMLMapping ? value.getParent() : value;
        if (YamlMetaTypeProvider.hasLineBreakBetweenKeyAndValue(keyValue, (PsiElement)keySibling)) {
            return Field.Relation.OBJECT_CONTENTS;
        }
        return Field.Relation.SCALAR_VALUE;
    }

    @Nullable
    private Field computeMetaType(@NotNull YAMLKeyValue keyValue) {
        YAMLMapping parentMapping = keyValue.getParentMapping();
        if (parentMapping == null) {
            YamlMetaTypeProvider.debug("Unexpected: keyValue parent is not a mapping: " + keyValue.getParent());
            return null;
        }
        MetaTypeProxy parentMeta = this.getMetaTypeProxy((PsiElement)parentMapping);
        return YamlMetaTypeProvider.findChildMeta(parentMeta, keyValue);
    }

    @Contract(value="null, _ -> null")
    @Nullable
    private static Field findChildMeta(@Nullable MetaTypeProxy parentMeta, @NotNull YAMLKeyValue child) {
        if (parentMeta == null) {
            return null;
        }
        String tag = child.getKeyText().trim();
        return parentMeta.getMetaType().findFeatureByName(tag);
    }

    @Nullable
    private static <T extends PsiElement> T getTypedAncestorOrSelf(@NotNull PsiElement psi, @NotNull Class<? extends T> clazz) {
        return (T)(clazz.isInstance(psi) ? (PsiElement)clazz.cast(psi) : PsiTreeUtil.getParentOfType((PsiElement)psi, clazz));
    }

    private static void debug(String text) {
        LOG.debug(text);
    }

    private static boolean hasLineBreakBetweenKeyAndValue(@NotNull YAMLKeyValue keyValue, @NotNull PsiElement keySibling) {
        if (keySibling.getParent() != keyValue) {
            return false;
        }
        PsiElement key = keyValue.getKey();
        for (PsiElement prev = keySibling.getPrevSibling(); prev != null && prev != key; prev = prev.getPrevSibling()) {
            if (prev.getNode().getElementType() != YAMLTokenTypes.EOL) continue;
            return true;
        }
        return false;
    }

    public static interface MetaTypeProxy {
        @NotNull
        public YamlMetaType getMetaType();

        @NotNull
        public Field getField();
    }

    public static class FieldAndRelation
    implements MetaTypeProxy {
        private final Field myField;
        private final Field.Relation myRelation;

        @Nullable
        public static FieldAndRelation forNullable(@Nullable Field field, @NotNull Field.Relation relation) {
            return field == null ? null : new FieldAndRelation(field, relation);
        }

        public FieldAndRelation(@NotNull Field field, @NotNull Field.Relation relation) {
            this.myField = field;
            this.myRelation = relation;
        }

        @Override
        @NotNull
        public Field getField() {
            return this.myField;
        }

        @NotNull
        public Field.Relation getRelation() {
            return this.myRelation;
        }

        public String toString() {
            return "[" + this.getField().getName() + " : " + (Object)((Object)this.getRelation()) + "]";
        }

        @Override
        @NotNull
        public YamlMetaType getMetaType() {
            return this.myField.getType(this.myRelation);
        }
    }
}

