/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.scale.ScaleType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class RowIcon
extends JBCachingScalableIcon<RowIcon>
implements com.intellij.ui.icons.RowIcon,
IconWithToolTip {
    private final RowIcon.Alignment myAlignment;
    private int myWidth;
    private int myHeight;
    private final Icon @NotNull [] myIcons;
    private Icon[] myScaledIcons;

    public RowIcon(int iconCount) {
        this(iconCount, RowIcon.Alignment.TOP);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public RowIcon(int iconCount, Alignment alignment) {
        this.getScaleContext().addUpdateListener(() -> this.updateSize());
        this.setAutoUpdateScaleContext(false);
        RowIcon.Alignment a = null;
        if (alignment == Alignment.TOP) {
            a = RowIcon.Alignment.TOP;
        } else if (alignment == Alignment.BOTTOM) {
            a = RowIcon.Alignment.BOTTOM;
        } else if (alignment == Alignment.CENTER) {
            a = RowIcon.Alignment.CENTER;
        }
        this.myAlignment = a;
        this.myIcons = new Icon[iconCount];
    }

    public RowIcon(int iconCount, RowIcon.Alignment alignment) {
        this.getScaleContext().addUpdateListener(() -> this.updateSize());
        this.setAutoUpdateScaleContext(false);
        this.myAlignment = alignment;
        this.myIcons = new Icon[iconCount];
    }

    public RowIcon(Icon ... icons) {
        this(icons.length);
        System.arraycopy(icons, 0, this.myIcons, 0, icons.length);
        this.updateSize();
    }

    protected RowIcon(@NotNull RowIcon icon) {
        super((JBCachingScalableIcon)icon);
        this.getScaleContext().addUpdateListener(() -> this.updateSize());
        this.setAutoUpdateScaleContext(false);
        this.myAlignment = icon.myAlignment;
        this.myWidth = icon.myWidth;
        this.myHeight = icon.myHeight;
        this.myIcons = (Icon[])ArrayUtil.copyOf((Object[])icon.myIcons);
        this.myScaledIcons = null;
    }

    @NotNull
    public RowIcon copy() {
        return new RowIcon(this);
    }

    @NotNull
    public com.intellij.ui.icons.RowIcon deepCopy() {
        RowIcon icon = new RowIcon(this);
        for (int i = 0; i < icon.myIcons.length; ++i) {
            icon.myIcons[i] = IconUtil.copy(icon.myIcons[i], null);
        }
        return icon;
    }

    private Icon @NotNull [] myScaledIcons() {
        if (this.myScaledIcons != null) {
            return this.myScaledIcons;
        }
        this.myScaledIcons = RowIcon.scaleIcons(this.myIcons, this.getScale());
        return this.myScaledIcons;
    }

    static Icon @NotNull [] scaleIcons(Icon @NotNull [] icons, float scale) {
        if (scale == 1.0f) {
            return icons;
        }
        Icon[] scaledIcons = new Icon[icons.length];
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] == null) continue;
            scaledIcons[i] = IconUtil.scale(icons[i], null, scale);
        }
        return scaledIcons;
    }

    public Icon @NotNull [] getAllIcons() {
        List icons = ContainerUtil.packNullables((Object[])this.myIcons);
        return icons.toArray(new Icon[0]);
    }

    public int hashCode() {
        return this.myIcons.length > 0 ? this.myIcons[0].hashCode() : 0;
    }

    public boolean equals(Object obj) {
        return obj instanceof RowIcon && Arrays.equals(((RowIcon)obj).myIcons, this.myIcons);
    }

    public int getIconCount() {
        return this.myIcons.length;
    }

    public void setIcon(Icon icon, int layer) {
        this.myIcons[layer] = icon;
        this.myScaledIcons = null;
        this.updateSize();
    }

    public Icon getIcon(int index) {
        return this.myIcons[index];
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        this.getScaleContext().update();
        int _x = x;
        int _y = y;
        for (Icon icon : this.myScaledIcons()) {
            if (icon == null) continue;
            switch (this.myAlignment) {
                case TOP: {
                    _y = y;
                    break;
                }
                case CENTER: {
                    _y = y + (this.myHeight - icon.getIconHeight()) / 2;
                    break;
                }
                case BOTTOM: {
                    _y = y + (this.myHeight - icon.getIconHeight());
                }
            }
            icon.paintIcon(c, g, _x, _y);
            _x += icon.getIconWidth();
        }
    }

    @Override
    public int getIconWidth() {
        this.getScaleContext().update();
        return (int)Math.ceil(this.scaleVal(this.myWidth, ScaleType.OBJ_SCALE));
    }

    @Override
    public int getIconHeight() {
        this.getScaleContext().update();
        return (int)Math.ceil(this.scaleVal(this.myHeight, ScaleType.OBJ_SCALE));
    }

    private void updateSize() {
        int width = 0;
        int height = 0;
        for (Icon icon : this.myIcons) {
            if (icon == null) continue;
            width += icon.getIconWidth();
            height = Math.max(height, icon.getIconHeight());
        }
        this.myWidth = width;
        this.myHeight = height;
    }

    @NotNull
    public Icon getDarkIcon(boolean isDark) {
        RowIcon newIcon = this.copy();
        for (int i = 0; i < newIcon.myIcons.length; ++i) {
            newIcon.myIcons[i] = newIcon.myIcons[i] == null ? null : IconLoader.getDarkIcon((Icon)newIcon.myIcons[i], (boolean)isDark);
        }
        return newIcon;
    }

    public String toString() {
        return "Row icon. myIcons=" + Arrays.asList(this.myIcons);
    }

    @Override
    public String getToolTip(boolean composite) {
        return LayeredIcon.combineIconTooltips(this.myIcons);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static enum Alignment {
        TOP,
        CENTER,
        BOTTOM;

    }
}

