/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.FirPlatformClassMapper;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/FirJavaClassMapper;", "Lorg/jetbrains/kotlin/fir/resolve/FirPlatformClassMapper;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "getCorrespondingPlatformClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "declaration", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "jvm"})
public final class FirJavaClassMapper
extends FirPlatformClassMapper {
    @NotNull
    private final FirSession session;

    public FirJavaClassMapper(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
    }

    @Override
    @Nullable
    public FirRegularClass getCorrespondingPlatformClass(@NotNull FirClassLikeDeclaration<?> declaration) {
        FirClassLikeDeclaration firClassLikeDeclaration;
        ClassId javaClassId;
        Intrinsics.checkNotNullParameter(declaration, (String)"declaration");
        FqNameUnsafe fqNameUnsafe = declaration.getSymbol().getClassId().asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"declaration.symbol.classId.asSingleFqName().toUnsafe()");
        ClassId classId = javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (classId == null) {
            firClassLikeDeclaration = null;
        } else {
            ClassId classId2 = classId;
            boolean bl = false;
            boolean bl2 = false;
            ClassId it = classId2;
            boolean bl3 = false;
            FirClassLikeSymbol<?> firClassLikeSymbol = MainSessionComponentsKt.getFirSymbolProvider(this.session).getClassLikeSymbolByFqName(it);
            firClassLikeDeclaration = firClassLikeSymbol == null ? null : (FirClassLikeDeclaration)firClassLikeSymbol.getFir();
        }
        fqNameUnsafe = firClassLikeDeclaration;
        return fqNameUnsafe instanceof FirRegularClass ? (FirRegularClass)((Object)fqNameUnsafe) : null;
    }
}

