/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.compilerRunner.KotlinLogger;
import org.jetbrains.kotlin.daemon.client.CompileServiceSession;
import org.jetbrains.kotlin.daemon.client.DaemonReportMessage;
import org.jetbrains.kotlin.daemon.client.DaemonReportingTargets;
import org.jetbrains.kotlin.daemon.client.KotlinCompilerClient;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.DaemonReportCategory;
import org.jetbrains.kotlin.daemon.common.DummyProfiler;
import org.jetbrains.kotlin.daemon.common.PerfCounters;
import org.jetbrains.kotlin.daemon.common.Profiler;
import org.jetbrains.kotlin.daemon.common.WallAndThreadAndMemoryTotalProfiler;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJQ\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007\u00a2\u0006\u0002\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/compilerRunner/KotlinCompilerRunnerUtils;", "", "()V", "exitCodeFromProcessExitCode", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "log", "Lorg/jetbrains/kotlin/compilerRunner/KotlinLogger;", "code", "", "newDaemonConnection", "Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "compilerId", "Lorg/jetbrains/kotlin/daemon/common/CompilerId;", "clientAliveFlagFile", "Ljava/io/File;", "sessionAliveFlagFile", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "isDebugEnabled", "", "daemonOptions", "Lorg/jetbrains/kotlin/daemon/common/DaemonOptions;", "additionalJvmParams", "", "", "(Lorg/jetbrains/kotlin/daemon/common/CompilerId;Ljava/io/File;Ljava/io/File;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;ZLorg/jetbrains/kotlin/daemon/common/DaemonOptions;[Ljava/lang/String;)Lorg/jetbrains/kotlin/daemon/client/CompileServiceSession;", "kotlin-compiler-runner"})
public final class KotlinCompilerRunnerUtils {
    @NotNull
    public static final KotlinCompilerRunnerUtils INSTANCE = new KotlinCompilerRunnerUtils();

    private KotlinCompilerRunnerUtils() {
    }

    @NotNull
    public final ExitCode exitCodeFromProcessExitCode(@NotNull KotlinLogger log2, int code) {
        ExitCode exitCode;
        block2: {
            ExitCode exitCode2;
            Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
            ExitCode[] exitCodeArray = ExitCode.values();
            boolean bl = false;
            ExitCode[] exitCodeArray2 = exitCodeArray;
            boolean bl2 = false;
            ExitCode[] exitCodeArray3 = exitCodeArray2;
            int n = exitCodeArray3.length;
            for (int i = 0; i < n; ++i) {
                ExitCode exitCode3;
                ExitCode it = exitCode3 = exitCodeArray3[i];
                boolean bl3 = false;
                if (!(it.getCode() == code)) continue;
                exitCode2 = exitCode3;
                break block2;
            }
            exitCode2 = exitCode = null;
        }
        if (exitCode != null) {
            return exitCode;
        }
        log2.debug(Intrinsics.stringPlus((String)"Could not find exit code by value: ", (Object)code));
        return code == 0 ? ExitCode.OK : ExitCode.COMPILATION_ERROR;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final synchronized CompileServiceSession newDaemonConnection(@NotNull CompilerId compilerId, @NotNull File clientAliveFlagFile, @NotNull File sessionAliveFlagFile, @NotNull MessageCollector messageCollector, boolean isDebugEnabled, @NotNull DaemonOptions daemonOptions, @NotNull String[] additionalJvmParams) {
        void $this$withMeasure$iv;
        Intrinsics.checkNotNullParameter((Object)compilerId, (String)"compilerId");
        Intrinsics.checkNotNullParameter((Object)clientAliveFlagFile, (String)"clientAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)sessionAliveFlagFile, (String)"sessionAliveFlagFile");
        Intrinsics.checkNotNullParameter((Object)messageCollector, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)daemonOptions, (String)"daemonOptions");
        Intrinsics.checkNotNullParameter((Object)additionalJvmParams, (String)"additionalJvmParams");
        String[] stringArray = new String[additionalJvmParams.length];
        System.arraycopy(additionalJvmParams, 0, stringArray, 0, additionalJvmParams.length);
        DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, true, false, true);
        ArrayList daemonReportMessages = new ArrayList();
        DaemonReportingTargets daemonReportingTargets = new DaemonReportingTargets(null, daemonReportMessages, null, null, 13, null);
        Profiler profiler = daemonOptions.getReportPerf() ? (Profiler)new WallAndThreadAndMemoryTotalProfiler(false) : (Profiler)new DummyProfiler();
        Profiler profiler2 = profiler;
        Object obj$iv = null;
        boolean $i$f$withMeasure = false;
        List<Long> startState$iv = $this$withMeasure$iv.beginMeasure(obj$iv);
        boolean bl = false;
        CompileServiceSession res$iv = KotlinCompilerClient.INSTANCE.connectAndLease(compilerId, clientAliveFlagFile, daemonJVMOptions, daemonOptions, daemonReportingTargets, true, true, sessionAliveFlagFile);
        $this$withMeasure$iv.endMeasure(obj$iv, startState$iv);
        CompileServiceSession connection = res$iv;
        if (connection == null || isDebugEnabled) {
            for (DaemonReportMessage message2 : daemonReportMessages) {
                CompilerMessageSeverity compilerMessageSeverity;
                DaemonReportCategory daemonReportCategory = message2.getCategory();
                int n = WhenMappings.$EnumSwitchMapping$0[daemonReportCategory.ordinal()];
                switch (n) {
                    case 1: {
                        compilerMessageSeverity = CompilerMessageSeverity.INFO;
                        break;
                    }
                    case 2: {
                        compilerMessageSeverity = CompilerMessageSeverity.INFO;
                        break;
                    }
                    case 3: {
                        compilerMessageSeverity = CompilerMessageSeverity.EXCEPTION;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                CompilerMessageSeverity severity = compilerMessageSeverity;
                MessageCollector.DefaultImpls.report$default(messageCollector, severity, message2.getMessage(), null, 4, null);
            }
        }
        KotlinCompilerRunnerUtils.newDaemonConnection$reportTotalAndThreadPerf("Daemon connect", daemonOptions, MessageCollector.Companion.getNONE(), profiler);
        return connection;
    }

    public static /* synthetic */ CompileServiceSession newDaemonConnection$default(CompilerId compilerId, File file2, File file3, MessageCollector messageCollector, boolean bl, DaemonOptions daemonOptions, String[] stringArray, int n, Object object) {
        if ((n & 0x20) != 0) {
            daemonOptions = DaemonParamsKt.configureDaemonOptions();
        }
        if ((n & 0x40) != 0) {
            stringArray = new String[]{};
        }
        return KotlinCompilerRunnerUtils.newDaemonConnection(compilerId, file2, file3, messageCollector, bl, daemonOptions, stringArray);
    }

    private static final long newDaemonConnection$reportTotalAndThreadPerf$ms(long $this$newDaemonConnection_u24reportTotalAndThreadPerf_u24ms) {
        return TimeUnit.NANOSECONDS.toMillis($this$newDaemonConnection_u24reportTotalAndThreadPerf_u24ms);
    }

    private static final void newDaemonConnection$reportTotalAndThreadPerf(String message2, DaemonOptions daemonOptions, MessageCollector messageCollector, Profiler profiler) {
        if (daemonOptions.getReportPerf()) {
            PerfCounters counters = profiler.getTotalCounters();
            MessageCollector.DefaultImpls.report$default(messageCollector, CompilerMessageSeverity.INFO, "PERF: " + message2 + ' ' + KotlinCompilerRunnerUtils.newDaemonConnection$reportTotalAndThreadPerf$ms(counters.getTime()) + " ms, thread " + KotlinCompilerRunnerUtils.newDaemonConnection$reportTotalAndThreadPerf$ms(counters.getThreadTime()), null, 4, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DaemonReportCategory.values().length];
            nArray[DaemonReportCategory.DEBUG.ordinal()] = 1;
            nArray[DaemonReportCategory.INFO.ordinal()] = 2;
            nArray[DaemonReportCategory.EXCEPTION.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

