/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProviderKt;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.load.kotlin.JvmPackagePartProviderBase;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\f0\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "Lcom/intellij/openapi/vfs/VirtualFile;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lcom/intellij/psi/search/GlobalSearchScope;)V", "deserializationConfiguration", "Lorg/jetbrains/kotlin/resolve/CompilerDeserializationConfiguration;", "loadedModules", "", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "getLoadedModules", "()Ljava/util/List;", "addRoots", "", "roots", "", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "cli"})
public final class JvmPackagePartProvider
extends JvmPackagePartProviderBase<VirtualFile> {
    @NotNull
    private final GlobalSearchScope scope;
    @NotNull
    private final CompilerDeserializationConfiguration deserializationConfiguration;
    @NotNull
    private final List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> loadedModules;

    public JvmPackagePartProvider(@NotNull LanguageVersionSettings languageVersionSettings, @NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        this.scope = scope2;
        this.deserializationConfiguration = new CompilerDeserializationConfiguration(languageVersionSettings);
        this.loadedModules = (List)new SmartList();
    }

    @Override
    @NotNull
    protected List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> getLoadedModules() {
        return this.loadedModules;
    }

    public final void addRoots(@NotNull List<JavaRoot> roots2, @NotNull MessageCollector messageCollector) {
        Intrinsics.checkParameterIsNotNull(roots2, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)messageCollector, (String)"messageCollector");
        for (JavaRoot javaRoot : roots2) {
            VirtualFile[] virtualFileArray;
            VirtualFile[] virtualFileArray2;
            VirtualFile root2 = javaRoot.component1();
            JavaRoot.RootType type2 = javaRoot.component2();
            if (type2 != JavaRoot.RootType.BINARY || !this.scope.contains(root2) || (virtualFileArray2 = root2.findChild("META-INF")) == null) continue;
            VirtualFile[] metaInf = virtualFileArray = virtualFileArray2;
            virtualFileArray2 = metaInf.getChildren();
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray2, (String)"metaInf.children");
            virtualFileArray = virtualFileArray2;
            int n = virtualFileArray.length;
            for (int i = 0; i < n; ++i) {
                VirtualFile moduleFile = virtualFileArray[i];
                Object object = moduleFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"moduleFile.name");
                if (!StringsKt.endsWith$default((String)object, (String)"kotlin_module", (boolean)false, (int)2, null)) continue;
                Function0 function0 = (Function0)new Function0<byte[]>(moduleFile){
                    final /* synthetic */ VirtualFile $moduleFile;
                    {
                        this.$moduleFile = $moduleFile;
                        super(0);
                    }

                    @NotNull
                    public final byte[] invoke() {
                        byte[] byArray = this.$moduleFile.contentsToByteArray();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"moduleFile.contentsToByteArray()");
                        return byArray;
                    }
                };
                Object object2 = moduleFile.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"moduleFile.toString()");
                String string2 = object2;
                object2 = moduleFile.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"moduleFile.path");
                object = JvmPackagePartProviderKt.tryLoadModuleMapping((Function0<byte[]>)function0, string2, (String)object2, this.deserializationConfiguration, messageCollector);
                if (object == null) continue;
                object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object2;
                boolean bl3 = false;
                List<JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>> list2 = this.getLoadedModules();
                String string3 = moduleFile.getNameWithoutExtension();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"moduleFile.nameWithoutExtension");
                list2.add(new JvmPackagePartProviderBase.ModuleMappingInfo<VirtualFile>(root2, (ModuleMapping)it, string3));
            }
        }
    }
}

