/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.psi.KtElement;

public class ReplaceStringQuickFix
implements LintIdeQuickFix {
    private final String myName;
    private final String myFamilyName;
    @RegExp
    private final String myRegexp;
    private final String myNewValue;
    private boolean myShortenNames;
    private boolean myFormat;
    private SmartPsiFileRange myRange;
    private String myExpandedNewValue;
    private String mySelectPattern;

    public ReplaceStringQuickFix(@Nullable String name, @Nullable String familyName, @Nullable @RegExp String regexp, @NotNull String newValue) {
        this.myName = name;
        this.myFamilyName = familyName;
        this.myNewValue = newValue;
        if (regexp != null && regexp.indexOf(40) == -1 && !regexp.equals("_lint_insert_begin_") && !regexp.equals("_lint_insert_end_")) {
            regexp = "(" + Pattern.quote(regexp) + ")";
        }
        this.myRegexp = regexp;
    }

    public ReplaceStringQuickFix setShortenNames(boolean shortenNames) {
        this.myShortenNames = shortenNames;
        return this;
    }

    public ReplaceStringQuickFix setFormat(boolean format) {
        this.myFormat = format;
        return this;
    }

    public ReplaceStringQuickFix setSelectPattern(String selectPattern) {
        this.mySelectPattern = selectPattern;
        return this;
    }

    public void setRange(SmartPsiFileRange range) {
        this.myRange = range;
    }

    @Override
    @NotNull
    public String getName() {
        if (this.myName == null) {
            if (this.myNewValue.isEmpty()) {
                return "Delete";
            }
            return "Replace with " + this.myNewValue;
        }
        return this.myName;
    }

    @Override
    @Nullable
    public String getFamilyName() {
        return this.myFamilyName;
    }

    @Nullable
    protected String getNewValue() {
        return this.myExpandedNewValue != null ? this.myExpandedNewValue : this.myNewValue;
    }

    protected void editBefore(@NotNull Document document) {
    }

    protected void editAfter(@NotNull Document document) {
    }

    @Override
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        PsiFile file = startElement.getContainingFile();
        if (this.myRange != null && (file = this.myRange.getContainingFile()) == null) {
            return;
        }
        Project project = startElement.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        Document document = documentManager.getDocument(file);
        if (document != null) {
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            this.editBefore(document);
            TextRange range = this.getRange(startElement, endElement, true);
            if (range != null) {
                Pattern pattern;
                Matcher matcher;
                String newValue = this.getNewValue();
                if (newValue == null) {
                    newValue = "";
                }
                if (ReplaceStringQuickFix.whitespaceOnly(newValue)) {
                    range = ReplaceStringQuickFix.includeFullLineIfOnlySpace(document, range);
                }
                int startOffset = range.getStartOffset();
                int endOffset = range.getEndOffset();
                document.replaceString(startOffset, endOffset, (CharSequence)newValue);
                endOffset = startOffset + newValue.length();
                this.editAfter(document);
                if (this.myShortenNames || this.myFormat) {
                    documentManager.commitDocument(document);
                    PsiElement element = file.findElementAt(startOffset);
                    if (element == null) {
                        return;
                    }
                    if (this.myShortenNames) {
                        Object parent;
                        PsiElement end = file.findElementAt(endOffset);
                        PsiElement psiElement = parent = end != null ? PsiTreeUtil.findCommonParent((PsiElement)element.getParent(), (PsiElement)end) : element.getParent();
                        if (parent == null) {
                            parent = element.getParent();
                        }
                        parent = element.getLanguage() == JavaLanguage.INSTANCE ? JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(parent) : (element.getLanguage() == KotlinLanguage.INSTANCE && parent instanceof KtElement ? ShortenReferences.DEFAULT.process((KtElement)parent) : null);
                        if (this.myFormat && parent != null) {
                            CodeStyleManager.getInstance((Project)project).reformat(parent);
                        } else {
                            CodeStyleManager.getInstance((Project)project).reformatRange(element, startOffset, endOffset);
                        }
                    } else if (this.myFormat) {
                        CodeStyleManager.getInstance((Project)project).reformatRange(element, startOffset, endOffset);
                    }
                }
                if (this.mySelectPattern != null && context instanceof AndroidQuickfixContexts.EditorContext && (matcher = (pattern = Pattern.compile(this.mySelectPattern)).matcher(document.getText())).find(startOffset)) {
                    int selectEnd;
                    int selectStart;
                    if (matcher.groupCount() > 0) {
                        selectStart = matcher.start(1);
                        selectEnd = matcher.end(1);
                    } else {
                        selectStart = matcher.start();
                        selectEnd = matcher.end();
                    }
                    Editor editor = ((AndroidQuickfixContexts.EditorContext)context).getEditor();
                    editor.getSelectionModel().setSelection(selectStart, selectEnd);
                }
            }
        }
    }

    private static boolean whitespaceOnly(@NotNull String text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static TextRange includeFullLineIfOnlySpace(@NotNull Document document, @NotNull TextRange range) {
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int lineStart = DocumentUtil.getLineStartOffset((int)startOffset, (Document)document);
        int lineEnd = DocumentUtil.getLineEndOffset((int)startOffset, (Document)document);
        if (lineEnd < endOffset) {
            return range;
        }
        String prefix = document.getText(new TextRange(lineStart, startOffset));
        String suffix = document.getText(new TextRange(endOffset, lineEnd));
        if (ReplaceStringQuickFix.whitespaceOnly(prefix) && ReplaceStringQuickFix.whitespaceOnly(suffix)) {
            return new TextRange(lineStart, lineEnd + 1);
        }
        return range;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private TextRange getRange(PsiElement startElement, PsiElement endElement, boolean computeReplacement) {
        int end;
        int start;
        if (!startElement.isValid() || !endElement.isValid()) {
            return null;
        }
        if (this.myRange != null) {
            PsiFile file = this.myRange.getContainingFile();
            if (file == null) {
                return null;
            }
            Segment segment = this.myRange.getRange();
            if (segment == null) return null;
            start = segment.getStartOffset();
            end = segment.getEndOffset();
            if (this.myRegexp != null && this.myRegexp != "_lint_insert_begin_" && this.myRegexp != "_lint_insert_end_") {
                startElement = file.findElementAt(start);
                endElement = file.findElementAt(end);
                if (startElement == null || endElement == null) {
                    return null;
                }
            }
        } else {
            start = startElement.getTextOffset();
            end = endElement.getTextOffset() + endElement.getTextLength();
        }
        if (this.myRegexp == null) return new TextRange(start, end);
        if ("_lint_insert_begin_".equals(this.myRegexp)) {
            return new TextRange(start, start);
        }
        if ("_lint_insert_end_".equals(this.myRegexp)) {
            return new TextRange(end, end);
        }
        try {
            String sequence;
            Pattern pattern = Pattern.compile(this.myRegexp, 8);
            PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
            if (parent != null && parent.getTextRange().containsRange(start, end)) {
                TextRange parentRange = parent.getTextRange();
                int offset = parentRange.getStartOffset();
                sequence = parent.getText().substring(start - offset, end - offset);
            } else {
                String text = startElement.getContainingFile().getText();
                sequence = text.substring(start, end);
            }
            Matcher matcher = pattern.matcher(sequence);
            if (!matcher.find()) return null;
            end = start;
            if (matcher.groupCount() > 0) {
                if (this.myRegexp.contains("target")) {
                    try {
                        start += matcher.start("target");
                        end += matcher.end("target");
                    }
                    catch (IllegalArgumentException ignore) {
                        start += matcher.start(1);
                        end += matcher.end(1);
                    }
                } else {
                    start += matcher.start(1);
                    end += matcher.end(1);
                }
            } else {
                start += matcher.start();
                end += matcher.end();
            }
            if (!computeReplacement || this.myExpandedNewValue != null) return new TextRange(start, end);
            this.myExpandedNewValue = LintFix.ReplaceString.expandBackReferences((String)this.myNewValue, (Matcher)matcher);
            return new TextRange(start, end);
        }
        catch (Exception e) {
            Logger.getInstance(ReplaceStringQuickFix.class).warn("Invalid regular expression " + this.myRegexp);
            return null;
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return this.getRange(startElement, endElement, false) != null;
    }
}

