/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator;

import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.sun.jdi.ClassLoaderReference;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassLoadingAdapter;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.debugger.evaluate.compilingEvaluator.ClassLoadingResult;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u001a\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\t"}, d2={"loadClasses", "Lcom/sun/jdi/ClassLoaderReference;", "context", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "loadClassesSafely", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/compilingEvaluator/ClassLoadingResult;", "kotlin.jvm-debugger.evaluation"})
public final class CompilingEvaluatorKt {
    @NotNull
    public static final ClassLoadingResult loadClassesSafely(@NotNull ExecutionContext context, @NotNull Collection<ClassToLoad> classes) {
        ClassLoadingResult classLoadingResult;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        if (classes.isEmpty()) {
            return ClassLoadingResult.NotNeeded.INSTANCE;
        }
        try {
            ClassLoaderReference cl = CompilingEvaluatorKt.loadClasses(context, classes);
            classLoadingResult = cl != null ? (ClassLoadingResult)new ClassLoadingResult.Success(cl) : (ClassLoadingResult)ClassLoadingResult.NotNeeded.INSTANCE;
        }
        catch (EvaluateException e) {
            throw (Throwable)e;
        }
        catch (Throwable e) {
            KotlinEvaluatorBuilderKt.getLOG().debug("Failed to evaluate expression", e);
            classLoadingResult = new ClassLoadingResult.Failure(e);
        }
        return classLoadingResult;
    }

    @Nullable
    public static final ClassLoaderReference loadClasses(@NotNull ExecutionContext context, @NotNull Collection<ClassToLoad> classes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(classes, (String)"classes");
        return ClassLoadingAdapter.Companion.loadClasses(context, classes);
    }
}

