/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.uipreview;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

@State(name="AndroidEditors", storages={@Storage(value="androidEditors.xml")})
public class AndroidEditorSettings
implements PersistentStateComponent<MyState> {
    private GlobalState myGlobalState = new GlobalState();

    public static AndroidEditorSettings getInstance() {
        return (AndroidEditorSettings)ServiceManager.getService(AndroidEditorSettings.class);
    }

    @NotNull
    public GlobalState getGlobalState() {
        return this.myGlobalState;
    }

    public MyState getState() {
        MyState state = new MyState();
        state.setState(this.myGlobalState);
        return state;
    }

    public void loadState(@NotNull MyState state) {
        this.myGlobalState = state.getState();
    }

    public static class GlobalState {
        private boolean myVisible = true;
        private boolean myHideForNonLayoutFiles = true;
        private boolean myShowDeviceFrames = true;
        private boolean myShowEffects = true;
        private boolean myRetina = true;
        private boolean myPreferXmlEditor = false;
        private boolean myShowLint = false;
        private EditorMode myPreferredEditorMode;
        private EditorMode myPreferredDrawableEditorMode;
        private boolean myEnableComposeInsertHandler = true;

        public boolean isRetina() {
            return this.myRetina;
        }

        public void setRetina(boolean retina) {
            this.myRetina = retina;
        }

        public boolean isVisible() {
            return this.myVisible;
        }

        public void setVisible(boolean visible) {
            this.myVisible = visible;
        }

        public boolean isHideForNonLayoutFiles() {
            return this.myHideForNonLayoutFiles;
        }

        public void setHideForNonLayoutFiles(boolean hideForNonLayoutFiles) {
            this.myHideForNonLayoutFiles = hideForNonLayoutFiles;
        }

        public boolean isShowDeviceFrames() {
            return this.myShowDeviceFrames;
        }

        public void setShowDeviceFrames(boolean showDeviceFrames) {
            this.myShowDeviceFrames = showDeviceFrames;
        }

        public boolean isShowEffects() {
            return this.myShowEffects;
        }

        public void setShowEffects(boolean showEffects) {
            this.myShowEffects = showEffects;
        }

        public boolean isPreferXmlEditor() {
            return this.myPreferXmlEditor;
        }

        public void setShowLint(boolean showLint) {
            this.myShowLint = showLint;
        }

        public boolean isShowLint() {
            return this.myShowLint;
        }

        public void setPreferXmlEditor(boolean preferXmlEditor) {
            this.myPreferXmlEditor = preferXmlEditor;
        }

        public EditorMode getPreferredEditorMode() {
            return this.myPreferredEditorMode;
        }

        public void setPreferredEditorMode(EditorMode preferredEditorMode) {
            this.myPreferredEditorMode = preferredEditorMode;
        }

        public EditorMode getPreferredDrawableEditorMode() {
            return this.myPreferredDrawableEditorMode;
        }

        public void setPreferredDrawableEditorMode(EditorMode preferredDrawableEditorMode) {
            this.myPreferredDrawableEditorMode = preferredDrawableEditorMode;
        }

        public boolean isComposeInsertHandlerEnabled() {
            return this.myEnableComposeInsertHandler;
        }

        public void setComposeInsertHandlerEnabled(boolean value2) {
            this.myEnableComposeInsertHandler = value2;
        }
    }

    public static class MyState {
        private GlobalState myGlobalState = new GlobalState();

        public GlobalState getState() {
            return this.myGlobalState;
        }

        public void setState(GlobalState state) {
            this.myGlobalState = state;
        }
    }

    public static enum EditorMode {
        CODE("Code", AllIcons.General.LayoutEditorOnly),
        SPLIT("Split", AllIcons.General.LayoutEditorPreview),
        DESIGN("Design", AllIcons.General.LayoutPreviewOnly);

        @NotNull
        private final String myDisplayName;
        @NotNull
        private final Icon myIcon;

        private EditorMode(String displayName, Icon icon2) {
            this.myDisplayName = displayName;
            this.myIcon = icon2;
        }

        @NotNull
        public String getDisplayName() {
            return this.myDisplayName;
        }

        @NotNull
        public Icon getIcon() {
            return this.myIcon;
        }
    }
}

