/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.sdk;

import com.android.repository.Revision;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.BuildToolInfo;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.io.FilePaths;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.reference.SoftReference;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.sdk.MessageBuildingSdkLog;
import org.jetbrains.android.util.AndroidBuildCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkData {
    private final Map<String, SoftReference<AndroidTargetData>> myTargetDataByTarget = Maps.newHashMap();
    private final DeviceManager myDeviceManager;
    private final int myPlatformToolsRevision;
    private static final ConcurrentMap<String, SoftReference<AndroidSdkData>> ourCache = Maps.newConcurrentMap();
    private AndroidSdkHandler mySdkHandler;

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull AndroidFacet facet2) {
        return ModuleSdkDataHolder.getInstance(facet2).getSdkData();
    }

    @NotNull
    public static AndroidSdkHandler getSdkHolder(@NotNull AndroidFacet facet2) {
        return ModuleSdkDataHolder.getInstance(facet2).getSdkHandler();
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation) {
        return AndroidSdkData.getSdkData(sdkLocation, false);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull File sdkLocation, boolean forceReparse) {
        SoftReference cachedRef;
        String canonicalPath = FileUtil.toCanonicalPath((String)sdkLocation.getPath());
        if (!forceReparse && (cachedRef = (SoftReference)ourCache.get(canonicalPath)) != null) {
            AndroidSdkData cachedData = (AndroidSdkData)cachedRef.get();
            if (cachedData == null) {
                ourCache.remove(canonicalPath, cachedRef);
            } else {
                return cachedData;
            }
        }
        File canonicalLocation = new File(canonicalPath);
        if (!IdeSdks.getInstance().isValidAndroidSdkPath(canonicalLocation)) {
            return null;
        }
        AndroidSdkData sdkData = new AndroidSdkData(canonicalLocation);
        ourCache.put(canonicalPath, (SoftReference<AndroidSdkData>)new SoftReference((Object)sdkData));
        return sdkData;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull String sdkPath) {
        File file2 = FilePaths.toSystemDependentPath((String)sdkPath);
        return AndroidSdkData.getSdkData(file2);
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Sdk sdk) {
        String sdkHomePath = sdk.getHomePath();
        if (sdkHomePath != null) {
            return AndroidSdkData.getSdkData(sdk.getHomePath());
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Project project) {
        Sdk sdk = ProjectRootManager.getInstance((Project)project).getProjectSdk();
        if (sdk != null) {
            return AndroidSdkData.getSdkData(sdk);
        }
        return null;
    }

    @Nullable
    public static AndroidSdkData getSdkData(@NotNull Module module2) {
        return AndroidSdkData.getSdkData(module2.getProject());
    }

    private AndroidSdkData(@NotNull File localSdk) {
        this.mySdkHandler = AndroidSdkHandler.getInstance((File)localSdk);
        File location = this.getLocation();
        String locationPath = location.getPath();
        Revision platformToolsRevision = AndroidBuildCommonUtils.parsePackageRevision((String)locationPath, (String)"platform-tools");
        this.myPlatformToolsRevision = platformToolsRevision == null ? -1 : platformToolsRevision.getMajor();
        this.myDeviceManager = DeviceManager.createInstance((AndroidSdkHandler)this.mySdkHandler, (ILogger)new MessageBuildingSdkLog());
    }

    @NotNull
    public File getLocation() {
        File location = this.mySdkHandler.getLocation();
        assert (location != null);
        return location;
    }

    @Deprecated
    @NotNull
    public String getPath() {
        return this.getLocation().getPath();
    }

    @Deprecated
    @Nullable
    public BuildToolInfo getLatestBuildTool() {
        return this.getLatestBuildTool(false);
    }

    @Nullable
    public BuildToolInfo getLatestBuildTool(boolean allowPreview) {
        return this.mySdkHandler.getLatestBuildTool((ProgressIndicator)new StudioLoggerProgressIndicator(this.getClass()), allowPreview);
    }

    @NotNull
    public IAndroidTarget[] getTargets() {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        return targets.toArray(new IAndroidTarget[0]);
    }

    @NotNull
    private Collection<IAndroidTarget> getTargetCollection() {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargets((ProgressIndicator)progress);
    }

    @NotNull
    public IAndroidTarget[] getTargets(boolean includeAddOns) {
        Collection<IAndroidTarget> targets = this.getTargetCollection();
        ArrayList result2 = Lists.newArrayList();
        if (!includeAddOns) {
            for (IAndroidTarget target : targets) {
                if (!target.isPlatform()) continue;
                result2.add(target);
            }
        } else {
            result2.addAll(targets);
        }
        return result2.toArray(new IAndroidTarget[0]);
    }

    @Nullable
    public IAndroidTarget findTargetByApiLevel(@NotNull String apiLevel) {
        for (IAndroidTarget target : this.getTargets()) {
            if (!AndroidSdkUtils.targetHasId(target, apiLevel)) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public IAndroidTarget findTargetByHashString(@NotNull String hashString) {
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        return this.mySdkHandler.getAndroidTargetManager((ProgressIndicator)progress).getTargetFromHashString(hashString, (ProgressIndicator)progress);
    }

    public int getPlatformToolsRevision() {
        return this.myPlatformToolsRevision;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AndroidSdkData sdkData = (AndroidSdkData)obj;
        return FileUtil.filesEqual((File)this.getLocation(), (File)sdkData.getLocation());
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.getLocation());
    }

    @NotNull
    public DeviceManager getDeviceManager() {
        return this.myDeviceManager;
    }

    @NotNull
    public AndroidTargetData getTargetData(@NotNull IAndroidTarget target) {
        AndroidTargetData targetData;
        String key = target.hashString();
        SoftReference<AndroidTargetData> targetDataRef = this.myTargetDataByTarget.get(key);
        AndroidTargetData androidTargetData = targetData = targetDataRef != null ? (AndroidTargetData)targetDataRef.get() : null;
        if (targetData == null) {
            targetData = new AndroidTargetData(this, target);
            this.myTargetDataByTarget.put(key, (SoftReference<AndroidTargetData>)new SoftReference((Object)targetData));
        }
        return targetData;
    }

    @NotNull
    public AndroidSdkHandler getSdkHandler() {
        return this.mySdkHandler;
    }

    private static class ModuleSdkDataHolder
    implements Disposable {
        private static final Key<ModuleSdkDataHolder> KEY = Key.create((String)ModuleSdkDataHolder.class.getName());
        private AndroidFacet myFacet;
        @NotNull
        private final AndroidSdkHandler mySdkHandler;
        @Nullable
        private final AndroidSdkData mySdkData;

        @NotNull
        static ModuleSdkDataHolder getInstance(@NotNull AndroidFacet facet2) {
            ModuleSdkDataHolder sdkDataHolder = (ModuleSdkDataHolder)facet2.getUserData(KEY);
            if (sdkDataHolder == null) {
                sdkDataHolder = new ModuleSdkDataHolder(facet2);
                facet2.putUserData(KEY, (Object)sdkDataHolder);
            }
            return sdkDataHolder;
        }

        ModuleSdkDataHolder(@NotNull AndroidFacet facet2) {
            this.myFacet = facet2;
            Disposer.register((Disposable)facet2, (Disposable)this);
            AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
            if (platform != null) {
                this.mySdkData = platform.getSdkData();
                this.mySdkHandler = this.mySdkData.getSdkHandler();
            } else {
                this.mySdkData = null;
                this.mySdkHandler = AndroidSdkHandler.getInstance(null);
            }
        }

        @Nullable
        AndroidSdkData getSdkData() {
            return this.mySdkData;
        }

        @NotNull
        AndroidSdkHandler getSdkHandler() {
            return this.mySdkHandler;
        }

        public void dispose() {
            this.myFacet.putUserData(KEY, null);
            this.myFacet = null;
        }
    }
}

