/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.resourceManagers;

import com.android.tools.idea.sdk.AndroidSdks;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.messages.MessageBusConnection;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ResourceManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleResourceManagers {
    private final Module myModule;
    private FrameworkResourceManager myPublicFrameworkResourceManager;
    private FrameworkResourceManager myFullFrameworkResourceManager;
    private LocalResourceManager myLocalResourceManager;

    @NotNull
    public static ModuleResourceManagers getInstance(@NotNull AndroidFacet facet2) {
        return (ModuleResourceManagers)facet2.getModule().getService(ModuleResourceManagers.class);
    }

    private ModuleResourceManagers(final @NotNull Module module2) {
        this.myModule = module2;
        MessageBusConnection connection = module2.getMessageBus().connect((Disposable)module2);
        connection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
            private Sdk myPrevSdk = null;

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                ModuleResourceManagers.this.myLocalResourceManager = null;
                Sdk newSdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                if (!(ModuleResourceManagers.this.myPublicFrameworkResourceManager == null && ModuleResourceManagers.this.myFullFrameworkResourceManager == null || Objects.equals(this.myPrevSdk, newSdk))) {
                    ModuleResourceManagers.this.myPublicFrameworkResourceManager = null;
                    ModuleResourceManagers.this.myFullFrameworkResourceManager = null;
                }
                this.myPrevSdk = newSdk;
            }
        });
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage) {
        return this.getResourceManager(resourcePackage, null);
    }

    @Nullable
    public ResourceManager getResourceManager(@Nullable String resourcePackage, @Nullable PsiElement contextElement) {
        if ("android".equals(resourcePackage)) {
            return this.getFrameworkResourceManager();
        }
        if (contextElement != null && AndroidSdks.getInstance().isInAndroidSdk(contextElement)) {
            return this.getFrameworkResourceManager();
        }
        return this.getLocalResourceManager();
    }

    @NotNull
    public LocalResourceManager getLocalResourceManager() {
        if (this.myLocalResourceManager == null || this.myLocalResourceManager.getFacet().isDisposed()) {
            this.myLocalResourceManager = new LocalResourceManager(this.getFacet());
        }
        return this.myLocalResourceManager;
    }

    @NotNull
    private AndroidFacet getFacet() {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)this.myModule);
        assert (facet2 != null);
        return facet2;
    }

    @Nullable
    public FrameworkResourceManager getFrameworkResourceManager() {
        return this.getFrameworkResourceManager(true);
    }

    @Nullable
    public FrameworkResourceManager getFrameworkResourceManager(boolean publicOnly) {
        if (publicOnly) {
            if (this.myPublicFrameworkResourceManager == null) {
                this.myPublicFrameworkResourceManager = new FrameworkResourceManager(this.myModule, true);
            }
            return this.myPublicFrameworkResourceManager;
        }
        if (this.myFullFrameworkResourceManager == null) {
            this.myFullFrameworkResourceManager = new FrameworkResourceManager(this.myModule, false);
        }
        return this.myFullFrameworkResourceManager;
    }
}

