/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.refactoring.renaming;

import com.android.ide.common.resources.ValueResourceNameValidator;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.ui.EditorTextField;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.refactoring.renaming.RenameResourceReferenceKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J-\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\b\u001a\u00020\tH\u0096\u0002J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u00132\u0006\u0010\b\u001a\u00020\tH\u0096\u0002\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceRenameHandler;", "Lcom/intellij/refactoring/rename/RenameHandler;", "Lcom/intellij/ide/TitledHandler;", "()V", "getActionTitle", "", "getWritableResourceReferenceElement", "Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "elements", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/actionSystem/DataContext;)V", "isAvailableInFile", "", "isAvailableOnDataContext", "isRenaming", "ResourceRenameDialog", "intellij.android.core"})
public class ResourceRenameHandler
implements RenameHandler,
TitledHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        if (!((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            return false;
        }
        PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile2 == null) {
            return false;
        }
        PsiFile file2 = psiFile2;
        return this.isAvailableInFile(file2) && this.getWritableResourceReferenceElement(dataContext) != null;
    }

    public boolean isAvailableInFile(@NotNull PsiFile file2) {
        return Intrinsics.areEqual((Object)file2.getLanguage(), (Object)KotlinLanguage.INSTANCE) ^ true;
    }

    private final ResourceReferencePsiElement getWritableResourceReferenceElement(DataContext dataContext) {
        ResourceReferencePsiElement resourceReferenceElement;
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement == null) {
            return null;
        }
        PsiElement element2 = psiElement;
        ResourceReferencePsiElement resourceReferencePsiElement = ResourceReferencePsiElement.Companion.create(element2);
        ResourceReferencePsiElement resourceReferencePsiElement2 = resourceReferenceElement = resourceReferencePsiElement != null ? resourceReferencePsiElement.toWritableResourceReferencePsiElement() : null;
        if (resourceReferenceElement != null) {
            return resourceReferenceElement;
        }
        Caret caret = (Caret)CommonDataKeys.CARET.getData(dataContext);
        if (caret == null) {
            return null;
        }
        int offset2 = caret.getOffset();
        PsiFile psiFile2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile file2 = psiFile2;
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement elementInFile = psiElement2;
        if (elementInFile.getParent() instanceof XmlTag) {
            return null;
        }
        ResourceReferencePsiElement resourceReferencePsiElement3 = IdeResourcesUtil.getResourceElementFromSurroundingValuesTag(elementInFile);
        return resourceReferencePsiElement3 != null ? resourceReferencePsiElement3.toWritableResourceReferencePsiElement() : null;
    }

    public boolean isRenaming(@NotNull DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor2, @Nullable PsiFile file2, @NotNull DataContext dataContext) {
        ResourceReferencePsiElement resourceReferencePsiElement = this.getWritableResourceReferenceElement(dataContext);
        if (resourceReferencePsiElement == null) {
            return;
        }
        ResourceReferencePsiElement referencePsiElement = resourceReferencePsiElement;
        if (file2 == null) {
            return;
        }
        referencePsiElement.putCopyableUserData(ResourceReferencePsiElement.RESOURCE_CONTEXT_ELEMENT, file2);
        String newName2 = (String)RenameResourceReferenceKt.getNEW_NAME_RESOURCE().getData(dataContext);
        new ResourceRenameDialog(project, referencePsiElement, null, editor2, newName2).show(dataContext);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, @NotNull DataContext dataContext) {
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        this.invoke(project, editor2, file2, dataContext);
    }

    @NotNull
    public String getActionTitle() {
        return "Rename Android Resource";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B5\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/android/refactoring/renaming/ResourceRenameHandler$ResourceRenameDialog;", "Lcom/intellij/refactoring/rename/RenameDialog;", "project", "Lcom/intellij/openapi/project/Project;", "resourceReferenceElement", "Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;", "nameSuggestionContext", "Lcom/intellij/psi/PsiElement;", "editor", "Lcom/intellij/openapi/editor/Editor;", "providedName", "", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/res/psi/ResourceReferencePsiElement;Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;Ljava/lang/String;)V", "canRun", "", "show", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "intellij.android.core"})
    private static final class ResourceRenameDialog
    extends RenameDialog {
        public final void show(@NotNull DataContext dataContext) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                String string = (String)RenameResourceReferenceKt.getNEW_NAME_RESOURCE().getData(dataContext);
                if (string == null) {
                    string = (String)PsiElementRenameHandler.DEFAULT_NAME.getData(dataContext);
                }
                if (string == null) {
                    return;
                }
                String newTestingName = string;
                this.performRename(newTestingName);
                this.close(0);
            } else {
                super.show();
            }
        }

        protected void canRun() {
            String name = this.getNewName();
            String errorText = ValueResourceNameValidator.getErrorText((String)name, null);
            if (errorText != null) {
                throw (Throwable)new ConfigurationException(errorText);
            }
        }

        public ResourceRenameDialog(@NotNull Project project, @NotNull ResourceReferencePsiElement resourceReferenceElement, @Nullable PsiElement nameSuggestionContext, @Nullable Editor editor2, @Nullable String providedName) {
            block2: {
                super(project, (PsiElement)resourceReferenceElement, nameSuggestionContext, editor2);
                if (providedName == null) break block2;
                JComponent jComponent = this.getNameSuggestionsField().getFocusableComponent();
                if (!(jComponent instanceof EditorTextField)) {
                    jComponent = null;
                }
                EditorTextField editorTextField2 = (EditorTextField)jComponent;
                if (editorTextField2 != null) {
                    editorTextField2.setText(providedName);
                }
            }
        }
    }
}

