/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.inspections.lint;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class RemoveAttributeQuickFix
implements LintIdeQuickFix {
    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class);
        if (attribute != null) {
            attribute.getParent().setAttribute(attribute.getName(), null);
        }
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class) != null;
    }

    @NotNull
    public String getName() {
        return AndroidBundle.message("android.lint.fix.remove.attribute", new Object[0]);
    }
}

