/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.facet;

import com.android.tools.idea.projectsystem.NamedIdeaSourceProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum AndroidSourceType {
    MANIFEST("manifest", it -> ImmutableList.copyOf(it.getManifestFiles()), AllIcons.Modules.SourceRoot),
    JAVA("java", it -> ImmutableList.copyOf(it.getJavaDirectories()), AllIcons.Modules.SourceRoot),
    GENERATED_JAVA(JAVA.getName(), null, AllIcons.Modules.GeneratedSourceRoot, true),
    CPP("cpp", it -> ImmutableList.copyOf(it.getJniDirectories()), AllIcons.Modules.SourceRoot),
    AIDL("aidl", it -> ImmutableList.copyOf(it.getAidlDirectories()), AllIcons.Modules.SourceRoot),
    RENDERSCRIPT("renderscript", it -> ImmutableList.copyOf(it.getRenderscriptDirectories()), AllIcons.Modules.SourceRoot),
    SHADERS("shaders", it -> ImmutableList.copyOf(it.getShadersDirectories()), AllIcons.Modules.SourceRoot),
    ASSETS("assets", it -> ImmutableList.copyOf(it.getAssetsDirectories()), AllIcons.Modules.ResourcesRoot),
    JNILIBS("jniLibs", it -> ImmutableList.copyOf(it.getJniLibsDirectories()), AllIcons.Modules.ResourcesRoot),
    RES("res", it -> ImmutableList.copyOf(it.getResDirectories()), AllIcons.Modules.ResourcesRoot),
    GENERATED_RES(RES.getName(), it -> ImmutableList.copyOf(it.getResDirectories()), AllIcons.Modules.ResourcesRoot, true),
    RESOURCES("resources", it -> ImmutableList.copyOf(it.getResourcesDirectories()), AllIcons.Modules.ResourcesRoot),
    ML("ml", it -> ImmutableList.copyOf(it.getMlModelsDirectories()), AllIcons.Modules.ResourcesRoot);

    private final String myName;
    private final Function<NamedIdeaSourceProvider, List<VirtualFile>> mySourceExtractor;
    private final Icon myIcon;
    private final boolean myGenerated;

    private AndroidSourceType(@NotNull String name, Function<NamedIdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon2) {
        this(name, sourceExtractor, icon2, false);
    }

    private AndroidSourceType(@NotNull String name, Function<NamedIdeaSourceProvider, List<VirtualFile>> sourceExtractor, Icon icon2, boolean generated) {
        this.myName = name;
        this.mySourceExtractor = sourceExtractor;
        this.myIcon = icon2;
        this.myGenerated = generated;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public List<VirtualFile> getSources(NamedIdeaSourceProvider provider2) {
        if (this.mySourceExtractor == null) {
            return Collections.emptyList();
        }
        List<VirtualFile> files2 = this.mySourceExtractor.apply(provider2);
        return files2 == null ? Collections.emptyList() : files2;
    }

    @Nullable
    public Icon getIcon() {
        return this.myIcon;
    }

    public boolean isGenerated() {
        return this.myGenerated;
    }
}

