/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.lint;

import com.android.tools.lint.detector.api.Severity;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SeverityConverter
extends ResolvingConverter<Severity> {
    private static final List<Severity> ALL_VALUES = ImmutableList.copyOf((Object[])Severity.values());

    @NotNull
    public Collection<Severity> getVariants(ConvertContext context) {
        return ALL_VALUES;
    }

    @Nullable
    public Severity fromString(@Nullable @NonNls String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        for (Severity severity : Severity.values()) {
            if (!severity.name().equalsIgnoreCase(s)) continue;
            return severity;
        }
        return null;
    }

    @Nullable
    public String toString(@Nullable Severity severity, ConvertContext context) {
        if (severity == null) {
            return null;
        }
        return StringUtil.toLowerCase((String)severity.name());
    }
}

