/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.compiler;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.model.AndroidModel;
import com.intellij.ProjectTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.android.compiler.AndroidAutogeneratorMode;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleSourceAutogenerating {
    private final Set<AndroidAutogeneratorMode> myDirtyModes = EnumSet.noneOf(AndroidAutogeneratorMode.class);
    private Sdk myPrevSdk;
    private final Map<AndroidAutogeneratorMode, Set<String>> myAutogeneratedFiles = new HashMap<AndroidAutogeneratorMode, Set<String>>();

    @Nullable
    public static ModuleSourceAutogenerating getInstance(@NotNull AndroidFacet facet2) {
        return (ModuleSourceAutogenerating)facet2.getModule().getService(ModuleSourceAutogenerating.class);
    }

    private ModuleSourceAutogenerating(final @NotNull Module module2) {
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null) {
            throw new IllegalArgumentException(module2.getName() + " is not an Android module");
        }
        if (!ModuleSourceAutogenerating.requiresAutoSourceGeneration(facet2)) {
            throw new IllegalArgumentException(module2.getName() + " is built by an external build system and should not require the IDE to generate sources");
        }
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.AAPT);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.AIDL);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.RENDERSCRIPT);
        this.scheduleSourceRegenerating(AndroidAutogeneratorMode.BUILDCONFIG);
        this.myPrevSdk = ModuleRootManager.getInstance((Module)module2).getSdk();
        module2.getMessageBus().connect((Disposable)facet2).subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                Sdk newSdk = ModuleRootManager.getInstance((Module)module2).getSdk();
                if (newSdk != null && newSdk.getSdkType() instanceof AndroidSdkType && !newSdk.equals(ModuleSourceAutogenerating.this.myPrevSdk)) {
                    ModuleSourceAutogenerating.this.myPrevSdk = newSdk;
                    ModuleSourceAutogenerating.this.resetRegeneratingState();
                }
            }
        });
    }

    public static boolean requiresAutoSourceGeneration(@NotNull AndroidFacet facet2) {
        return !AndroidModel.isRequired(facet2) && ApkFacet.getInstance(facet2.getModule()) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isGeneratedFileRemoved(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> filePaths = this.myAutogeneratedFiles.get((Object)mode);
            if (filePaths != null) {
                for (String path2 : filePaths) {
                    VirtualFile file2 = LocalFileSystem.getInstance().findFileByPath(path2);
                    if (file2 != null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set != null) {
                set.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markFileAutogenerated(@NotNull AndroidAutogeneratorMode mode, @NotNull VirtualFile file2) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            if (set == null) {
                set = new HashSet<String>();
                this.myAutogeneratedFiles.put(mode, set);
            }
            set.add(file2.getPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<String> getAutogeneratedFiles(@NotNull AndroidAutogeneratorMode mode) {
        Map<AndroidAutogeneratorMode, Set<String>> map2 = this.myAutogeneratedFiles;
        synchronized (map2) {
            Set<String> set = this.myAutogeneratedFiles.get((Object)mode);
            return set != null ? new HashSet<String>(set) : Collections.emptySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleSourceRegenerating(@NotNull AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            this.myDirtyModes.add(mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cleanRegeneratingState(@NotNull AndroidAutogeneratorMode mode) {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            return this.myDirtyModes.remove((Object)mode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetRegeneratingState() {
        Set<AndroidAutogeneratorMode> set = this.myDirtyModes;
        synchronized (set) {
            Collections.addAll(this.myDirtyModes, AndroidAutogeneratorMode.values());
        }
    }
}

