/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.sdklib.internal.avd.AvdInfo;
import com.android.tools.idea.avdmanager.AvdListDialog;
import com.android.tools.idea.avdmanager.HardwareAccelerationCheck;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunAndroidAvdManagerAction
extends DumbAwareAction {
    public static final String ID = "Android.RunAndroidAvdManager";
    @Nullable
    private AvdListDialog myDialog;

    public void update(@NotNull AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        switch (event.getPlace()) {
            case "toolbar": {
                presentation.setText("Add Device Definition...");
                presentation.setIcon(null);
                break;
            }
            case "unknown": {
                presentation.setText("Open AVD Manager");
                break;
            }
            default: {
                presentation.setText("AVD Manager");
            }
        }
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            presentation.setVisible(false);
            return;
        }
        presentation.setEnabled(AndroidSdkUtils.isAndroidSdkAvailable());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        this.openAvdManager(e.getProject());
    }

    public void openAvdManager(@Nullable Project project) {
        if (HardwareAccelerationCheck.isChromeOSAndIsNotHWAccelerated()) {
            return;
        }
        if (this.myDialog == null) {
            this.myDialog = new AvdListDialog(project);
            this.myDialog.init();
            this.myDialog.show();
            Disposer.register((Disposable)this.myDialog, () -> {
                this.myDialog = null;
            });
        } else {
            this.myDialog.getFrame().toFront();
        }
    }

    @Nullable
    public AvdInfo getSelected() {
        return this.myDialog == null ? null : this.myDialog.getSelected();
    }
}

