/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.actions;

import com.android.resources.ResourceFolderType;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.CommonBundle;
import com.intellij.ide.actions.ElementCreator;
import com.intellij.ide.actions.TemplateKindCombo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.PlatformIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.android.AndroidFileTemplateProvider;
import org.jetbrains.android.actions.CreateResourceFileAction;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Application;
import org.jetbrains.android.dom.manifest.ApplicationComponent;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.dom.resources.ResourceValue;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidRootUtil;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewAndroidComponentDialog
extends DialogWrapper {
    private JPanel myPanel;
    private JLabel myKindLabel;
    private JTextField myNameField;
    private JLabel myUpDownHint;
    private TemplateKindCombo myKindCombo;
    private JTextField myLabelField;
    private JCheckBox myMarkAsStartupActivityCheckBox;
    private JBCheckBox myCreateLayoutFile;
    private ElementCreator myCreator;
    private PsiElement[] myCreatedElements;

    public NewAndroidComponentDialog(final @NotNull Module module2, final @NotNull PsiDirectory directory) {
        super(module2.getProject());
        this.$$$setupUI$$$();
        this.myKindLabel.setLabelFor((Component)this.myKindCombo);
        this.myKindCombo.registerUpDownHint((JComponent)this.myNameField);
        this.myUpDownHint.setIcon(PlatformIcons.UP_DOWN_ARROWS);
        this.myKindCombo.addItem(AndroidBundle.message("android.new.component.dialog.activity.item", new Object[0]), null, "Activity.java");
        this.myKindCombo.addItem(AndroidBundle.message("android.new.component.dialog.fragment.item", new Object[0]), null, "Fragment.java");
        if (!NewAndroidComponentDialog.containsCustomApplicationClass(module2)) {
            this.myKindCombo.addItem(AndroidBundle.message("android.new.component.dialog.application.item", new Object[0]), null, "Application.java");
        }
        this.myKindCombo.addItem(AndroidBundle.message("android.new.component.dialog.service.item", new Object[0]), null, "Service.java");
        this.myKindCombo.addItem(AndroidBundle.message("android.new.component.dialog.broadcast.receiver.item", new Object[0]), null, "Broadcast_Receiver.java");
        this.myKindCombo.addItem(AndroidBundle.message("android.new.component.dialog.broadcast.remote.interface", new Object[0]), null, "Remote_Interface.aidl");
        this.init();
        this.setTitle(AndroidBundle.message("android.new.component.action.command.name", new Object[0]));
        this.myCreator = new ElementCreator(module2.getProject(), CommonBundle.getErrorTitle()){

            protected PsiElement[] create(String newName2) throws Exception {
                PsiElement element2 = NewAndroidComponentDialog.this.create(newName2, directory, module2.getProject());
                if (element2 != null) {
                    return new PsiElement[]{element2};
                }
                return PsiElement.EMPTY_ARRAY;
            }

            protected String getActionName(String newName2) {
                return AndroidBundle.message("android.new.component.action.command.name", new Object[0]);
            }
        };
        this.myKindCombo.getComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selected = NewAndroidComponentDialog.this.myKindCombo.getSelectedName();
                NewAndroidComponentDialog.this.myMarkAsStartupActivityCheckBox.setEnabled("Activity.java".equals(selected));
                NewAndroidComponentDialog.this.myCreateLayoutFile.setEnabled("Activity.java".equals(selected) || "Fragment.java".equals(selected));
                NewAndroidComponentDialog.this.myLabelField.setEnabled(!"Remote_Interface.aidl".equals(selected) && !"Application.java".equals(selected) && !"Fragment.java".equals(selected));
            }
        });
    }

    private static boolean containsCustomApplicationClass(final @NotNull Module module2) {
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module2.getProject());
        PsiClass applicationClass = (PsiClass)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiClass>(){

            @Nullable
            public PsiClass compute() {
                return facade.findClass("android.app.Application", module2.getModuleWithDependenciesAndLibrariesScope(false));
            }
        });
        return applicationClass != null && ClassInheritorsSearch.search((PsiClass)applicationClass, (SearchScope)module2.getModuleScope(), (boolean)true).findFirst() != null;
    }

    @Nullable
    private PsiElement create(String newName2, PsiDirectory directory, Project project) throws Exception {
        return NewAndroidComponentDialog.doCreate(this.myKindCombo.getSelectedName(), directory, project, newName2, this.myLabelField.getText(), this.myMarkAsStartupActivityCheckBox.isSelected(), this.myCreateLayoutFile.isSelected());
    }

    @Nullable
    static PsiElement doCreate(String templateName, final PsiDirectory directory, Project project, String newName2, String label, boolean startupActivity, boolean createLayoutFile) throws Exception {
        final PsiElement element2 = AndroidFileTemplateProvider.createFromTemplate(templateName, newName2, directory);
        if (element2 == null) {
            return null;
        }
        Module module2 = ModuleUtil.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project);
        if (module2 != null) {
            final AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
            assert (facet2 != null);
            if (element2 instanceof PsiClass) {
                NewAndroidComponentDialog.registerComponent(templateName, (PsiClass)element2, JavaDirectoryService.getInstance().getPackage(directory), facet2, label, startupActivity);
                if (("Activity.java".equals(templateName) || "Fragment.java".equals(templateName)) && createLayoutFile) {
                    String appPackage;
                    final boolean isActivity = "Activity.java".equals(templateName);
                    Manifest manifest = Manifest.getMainManifest(facet2);
                    String string = appPackage = manifest != null ? (String)manifest.getPackage().getValue() : null;
                    if (appPackage != null && !appPackage.isEmpty()) {
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewAndroidComponentDialog.createLayoutFileForActivityOrFragment(facet2, (PsiClass)element2, appPackage, directory, isActivity);
                            }
                        });
                    }
                }
            }
        }
        return element2;
    }

    private static void createLayoutFileForActivityOrFragment(@NotNull AndroidFacet facet2, @NotNull PsiClass activityClass, @NotNull String appPackage, @NotNull PsiDirectory resDirectory, boolean activity) {
        String layoutFileName;
        if (facet2.isDisposed() || !activityClass.isValid()) {
            return;
        }
        String className2 = activityClass.getName();
        if (className2 == null) {
            return;
        }
        XmlFile layoutFile = CreateResourceFileAction.createFileResource(facet2, ResourceFolderType.LAYOUT, null, null, null, true, "Create Layout For '" + className2 + "'", resDirectory, null, false);
        String string = layoutFileName = layoutFile != null ? layoutFile.getName() : null;
        if (layoutFileName != null) {
            PsiMethod[] onCreateMethods = activityClass.findMethodsByName(activity ? "onCreate" : "onCreateView", false);
            if (onCreateMethods.length != 1) {
                return;
            }
            PsiMethod onCreateMethod = onCreateMethods[0];
            PsiCodeBlock body = onCreateMethod.getBody();
            if (body != null) {
                String fieldName = IdeResourcesUtil.getRJavaFieldName(FileUtil.getNameWithoutExtension((String)layoutFileName));
                String layoutFieldRef = appPackage + ".R.layout." + fieldName;
                if (activity) {
                    NewAndroidComponentDialog.addSetContentViewStatement(body, layoutFieldRef);
                } else {
                    NewAndroidComponentDialog.addInflateStatement(body, layoutFieldRef);
                }
            }
        }
    }

    private static void addInflateStatement(final PsiCodeBlock body, final String layoutFieldRef) {
        final Project project = body.getProject();
        PsiStatement[] statements = body.getStatements();
        if (statements.length == 1) {
            final PsiStatement statement = statements[0];
            new WriteCommandAction(project, new PsiFile[]{body.getContainingFile()}){

                protected void run(@NotNull Result result2) throws Throwable {
                    PsiStatement newStatement = PsiElementFactory.getInstance((Project)project).createStatementFromText("return inflater.inflate(" + layoutFieldRef + ", container, false);", (PsiElement)body);
                    statement.replace((PsiElement)newStatement);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)body);
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)body);
                }
            }.execute();
        }
    }

    private static void addSetContentViewStatement(final PsiCodeBlock body, final String layoutFieldRef) {
        final Project project = body.getProject();
        final PsiElement lastBodyElement = body.getLastBodyElement();
        if (lastBodyElement != null) {
            new WriteCommandAction(project, new PsiFile[]{body.getContainingFile()}){

                protected void run(@NotNull Result result2) throws Throwable {
                    PsiStatement newStatement = PsiElementFactory.getInstance((Project)project).createStatementFromText("setContentView(" + layoutFieldRef + ");", (PsiElement)body);
                    body.addAfter((PsiElement)newStatement, lastBodyElement);
                    JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)body);
                    CodeStyleManager.getInstance((Project)project).reformat((PsiElement)body);
                }
            }.execute();
        }
    }

    protected static void registerComponent(String templateName, PsiClass aClass, PsiPackage aPackage, AndroidFacet facet2, String label, boolean startupActivity) {
        Application application;
        VirtualFile manifestFile = AndroidRootUtil.getPrimaryManifestFile(facet2);
        if (manifestFile == null || !ReadonlyStatusHandler.ensureFilesWritable((Project)facet2.getModule().getProject(), (VirtualFile[])new VirtualFile[]{manifestFile})) {
            return;
        }
        Manifest manifest = AndroidUtils.loadDomElement(facet2.getModule(), manifestFile, Manifest.class);
        if (manifest == null) {
            return;
        }
        String packageName = (String)manifest.getPackage().getValue();
        if (packageName == null || packageName.isEmpty()) {
            manifest.getPackage().setValue((Object)aPackage.getQualifiedName());
        }
        if ((application = manifest.getApplication()) == null) {
            return;
        }
        ApplicationComponent component = NewAndroidComponentDialog.addToManifest(templateName, aClass, application, startupActivity);
        if (component != null && !label.isEmpty()) {
            component.getLabel().setValue(ResourceValue.literal(label));
        }
    }

    @Nullable
    protected static ApplicationComponent addToManifest(String templateName, @NotNull PsiClass aClass, @NotNull Application application, boolean startupActivity) {
        if ("Activity.java".equals(templateName)) {
            Activity activity = application.addActivity();
            activity.getActivityClass().setValue(aClass);
            if (startupActivity) {
                IntentFilter filter2 = activity.addIntentFilter();
                Action action2 = filter2.addAction();
                action2.getName().setValue("android.intent.action.MAIN");
                Category category = filter2.addCategory();
                category.getName().setValue("android.intent.category.LAUNCHER");
            }
            return activity;
        }
        if ("Service.java".equals(templateName)) {
            Service service = application.addService();
            service.getServiceClass().setValue(aClass);
            return service;
        }
        if ("Broadcast_Receiver.java".equals(templateName)) {
            Receiver receiver = application.addReceiver();
            receiver.getReceiverClass().setValue(aClass);
            return receiver;
        }
        if ("Application.java".equals(templateName)) {
            application.getName().setValue(aClass);
        }
        return null;
    }

    protected void doOKAction() {
        this.myCreatedElements = this.myCreator.tryCreate(this.myNameField.getText());
        if (this.myCreatedElements.length == 0) {
            return;
        }
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myNameField;
    }

    protected String getHelpId() {
        return "reference.new.android.component";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @NotNull
    public PsiElement[] getCreatedElements() {
        return this.myCreatedElements;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JCheckBox jCheckBox;
        TemplateKindCombo templateKindCombo;
        JLabel jLabel;
        JTextField jTextField2;
        JLabel jLabel2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myKindLabel = jLabel2 = new JLabel();
        jLabel2.setText("Kind:");
        jLabel2.setDisplayedMnemonic('K');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameField = jTextField2 = new JTextField();
        jTextField2.setColumns(30);
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(250, -1), null));
        this.myUpDownHint = jLabel = new JLabel();
        jLabel.setToolTipText("Pressing Up or Down arrows while in editor changes the kind");
        jPanel.add((Component)jLabel, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myKindCombo = templateKindCombo = new TemplateKindCombo();
        jPanel.add((Component)templateKindCombo, new GridConstraints(1, 1, 1, 2, 0, 1, 3, 3, null, null, null));
        this.myMarkAsStartupActivityCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Mark as startup Activity");
        jCheckBox.setMnemonic('M');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myLabelField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(2, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Label:");
        jLabel4.setDisplayedMnemonic('L');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCreateLayoutFile = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Create layout file");
        jBCheckBox.setMnemonic('Y');
        jBCheckBox.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jBCheckBox, new GridConstraints(4, 0, 1, 3, 0, 1, 0, 0, null, null, null));
        jLabel3.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

