/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.module.impl.scopes.JdkScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ResolveScopeProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.android.augment.AndroidInternalRClass;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidSdkType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkResolveScopeProvider
extends ResolveScopeProvider {
    @Nullable
    public GlobalSearchScope getResolveScope(@NotNull VirtualFile file2, Project project) {
        Sdk sdk;
        if (!ProjectFacetManager.getInstance((Project)project).hasFacets(AndroidFacet.ID)) {
            return null;
        }
        ProjectFileIndex index2 = ProjectRootManager.getInstance((Project)project).getFileIndex();
        JdkOrderEntry entry = (JdkOrderEntry)ContainerUtil.findInstance((Iterable)index2.getOrderEntriesForFile(file2), JdkOrderEntry.class);
        Sdk sdk2 = sdk = entry == null ? null : entry.getJdk();
        if (sdk == null || !(sdk.getSdkType() instanceof AndroidSdkType)) {
            return null;
        }
        return new MyJdkScope(project, entry, index2.isInLibrarySource(file2));
    }

    public static class MyJdkScope
    extends JdkScope {
        @Nullable
        private final Sdk mySdk;
        private final boolean myIncludeSource;

        private MyJdkScope(Project project, @NotNull JdkOrderEntry entry, boolean includeSource) {
            super(project, entry.getRootFiles(OrderRootType.CLASSES), includeSource ? entry.getRootFiles(OrderRootType.SOURCES) : VirtualFile.EMPTY_ARRAY, entry.getJdkName());
            this.myIncludeSource = includeSource;
            this.mySdk = entry.getJdk();
        }

        public boolean isForceSearchingInLibrarySources() {
            return this.myIncludeSource;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            boolean inSources1 = this.myIndex.isInLibrarySource(file1);
            if (inSources1 != this.myIndex.isInLibrarySource(file2) && !"Object".equals(file1.getNameWithoutExtension())) {
                return inSources1 ? 1 : -1;
            }
            return super.compare(file1, file2);
        }

        public boolean contains(@NotNull VirtualFile file2) {
            return super.contains(file2) || this.mySdk != null && AndroidInternalRClass.isAndroidInternalR(file2, this.mySdk);
        }
    }
}

