/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.annotations.concurrency.WorkerThread;
import com.android.resources.ResourceFolderType;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.psi.ResourceReferencePsiElement;
import com.google.common.collect.ObjectArrays;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.android.dom.resources.ResourcesDomFileDescription;
import org.jetbrains.android.dom.wrappers.LazyValueResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ResourceElementWrapper;
import org.jetbrains.android.dom.wrappers.ValueResourceElementWrapper;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.android.resourceManagers.ValueResourceInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    @WorkerThread
    public boolean canFindUsages(@NotNull PsiElement element2) {
        AndroidFacet facet2;
        XmlAttributeValue value2;
        if (((Boolean)StudioFlags.RESOLVE_USING_REPOS.get()).booleanValue()) {
            return false;
        }
        if (element2 instanceof ResourceReferencePsiElement) {
            return true;
        }
        if (element2 instanceof LazyValueResourceElementWrapper) {
            return true;
        }
        if (element2 instanceof XmlAttributeValue && IdeResourcesUtil.isIdDeclaration(value2 = (XmlAttributeValue)element2)) {
            return true;
        }
        if ((element2 = AndroidFindUsagesHandlerFactory.correctResourceElement(element2)) instanceof PsiField) {
            return IdeResourcesUtil.isResourceField((PsiField)element2);
        }
        if ((element2 instanceof PsiFile || element2 instanceof XmlTag) && (facet2 = AndroidFacet.getInstance((PsiElement)element2)) != null) {
            LocalResourceManager resourceManager = ModuleResourceManagers.getInstance(facet2).getLocalResourceManager();
            if (element2 instanceof PsiFile) {
                return resourceManager.getFileResourceFolderType((PsiFile)element2) != null;
            }
            ResourceFolderType fileResType = resourceManager.getFileResourceFolderType(element2.getContainingFile());
            if (ResourceFolderType.VALUES == fileResType) {
                return IdeResourcesUtil.getResourceTypeForResourceTag((XmlTag)element2) != null;
            }
        }
        return false;
    }

    @Nullable
    private static PsiElement correctResourceElement(PsiElement element2) {
        if (element2 instanceof XmlElement && !(element2 instanceof XmlFile)) {
            PsiFile file2;
            XmlTag tag;
            XmlTag xmlTag = tag = element2 instanceof XmlTag ? (XmlTag)element2 : (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element2, XmlTag.class);
            if (tag != null && (file2 = tag.getContainingFile()) instanceof XmlFile && ResourcesDomFileDescription.isResourcesFile((XmlFile)file2)) {
                return tag;
            }
            return null;
        }
        return element2;
    }

    private static XmlAttributeValue wrapIfNecessary(XmlAttributeValue value2) {
        if (value2 instanceof ResourceElementWrapper) {
            return value2;
        }
        return new ValueResourceElementWrapper(value2);
    }

    @WorkerThread
    @Nullable
    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element2, boolean forHighlightUsages) {
        XmlAttributeValue value2;
        if (element2 instanceof ResourceReferencePsiElement) {
            return new MyFindUsagesHandler(element2, PsiElement.EMPTY_ARRAY);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)element2.getContainingFile());
        if (facet2 == null) {
            return null;
        }
        if (element2 instanceof LazyValueResourceElementWrapper) {
            ValueResourceInfo resourceInfo = ((LazyValueResourceElementWrapper)element2).getResourceInfo();
            PsiField[] resourceFields = forHighlightUsages ? PsiField.EMPTY_ARRAY : IdeResourcesUtil.findResourceFields(facet2, resourceInfo.getType().getName(), resourceInfo.getName(), true);
            return new MyFindUsagesHandler(element2, (PsiElement[])resourceFields);
        }
        if (element2 instanceof XmlAttributeValue && IdeResourcesUtil.isIdDeclaration(value2 = (XmlAttributeValue)element2)) {
            element2 = AndroidFindUsagesHandlerFactory.wrapIfNecessary(value2);
            PsiField[] fields = forHighlightUsages ? PsiField.EMPTY_ARRAY : IdeResourcesUtil.findIdFields(value2);
            return new MyFindUsagesHandler(element2, (PsiElement[])fields);
        }
        if ((element2 = AndroidFindUsagesHandlerFactory.correctResourceElement(element2)) instanceof PsiFile) {
            PsiField[] fields;
            PsiField[] psiFieldArray = fields = forHighlightUsages ? PsiField.EMPTY_ARRAY : IdeResourcesUtil.findResourceFieldsForFileResource((PsiFile)element2, true);
            if (fields.length == 0) {
                return null;
            }
            return new MyFindUsagesHandler(element2, (PsiElement[])fields);
        }
        if (element2 instanceof XmlTag) {
            XmlAttributeValue nameValue;
            XmlTag tag = (XmlTag)element2;
            XmlAttribute nameAttr = tag.getAttribute("name");
            XmlAttributeValue xmlAttributeValue = nameValue = nameAttr != null ? nameAttr.getValueElement() : null;
            assert (nameValue != null);
            Object[] fields = PsiField.EMPTY_ARRAY;
            if (!forHighlightUsages) {
                fields = IdeResourcesUtil.findResourceFieldsForValueResource(tag, true);
                if (fields.length == 0) {
                    return null;
                }
                Object[] styleableFields = IdeResourcesUtil.findStyleableAttributeFields(tag, true);
                if (styleableFields.length > 0) {
                    fields = (PsiField[])ObjectArrays.concat((Object[])fields, (Object[])styleableFields, PsiField.class);
                }
            }
            return new MyFindUsagesHandler((PsiElement)nameValue, (PsiElement[])fields);
        }
        if (element2 instanceof PsiField) {
            PsiField field2 = (PsiField)element2;
            List<PsiElement> resources = IdeResourcesUtil.findResourcesByField(field2);
            if (resources.isEmpty()) {
                return new MyFindUsagesHandler(element2, new PsiElement[0]);
            }
            PsiElement resource = resources.get(0);
            return this.createFindUsagesHandler(resource, forHighlightUsages);
        }
        return null;
    }

    private static class MyFindUsagesHandler
    extends FindUsagesHandler {
        private final PsiElement[] myAdditionalElements;

        protected MyFindUsagesHandler(@NotNull PsiElement element2, PsiElement ... additionalElements) {
            super(element2);
            this.myAdditionalElements = additionalElements;
        }

        @NotNull
        public PsiElement[] getSecondaryElements() {
            return this.myAdditionalElements;
        }
    }
}

