/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.SdkConstants;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.android.dom.converters.OnClickConverter;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidClassMembersImplicitUsagesProvider
implements ImplicitUsageProvider {
    public boolean isImplicitUsage(@NotNull PsiElement element2) {
        if (element2 instanceof PsiField) {
            return AndroidClassMembersImplicitUsagesProvider.isImplicitFieldUsage((PsiField)element2);
        }
        if (element2 instanceof PsiParameter) {
            return AndroidClassMembersImplicitUsagesProvider.isImplicitParameterUsage((PsiParameter)element2);
        }
        if (element2 instanceof PsiMethod) {
            PsiMethod method2 = (PsiMethod)element2;
            if (method2.isConstructor()) {
                return this.isImplicitConstructorUsage(method2);
            }
            return this.isImplicitMethodUsage(method2);
        }
        return false;
    }

    private static boolean isImplicitParameterUsage(@NotNull PsiParameter parameter) {
        if (AndroidFacet.getInstance((PsiElement)parameter) == null) {
            return false;
        }
        PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiMethod.class);
        if (method2 == null || !OnClickConverter.CONVERTER_FOR_LAYOUT.checkSignature(method2) && !OnClickConverter.CONVERTER_FOR_MENU.checkSignature(method2)) {
            return false;
        }
        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method2, PsiClass.class);
        if (aClass == null) {
            return false;
        }
        PsiClass activityBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("android.app.Activity", parameter.getResolveScope());
        if (activityBaseClass == null) {
            return false;
        }
        return aClass.isInheritor(activityBaseClass, true);
    }

    private static boolean isImplicitFieldUsage(@NotNull PsiField field2) {
        if (!"CREATOR".equals(field2.getName())) {
            return false;
        }
        PsiModifierList modifierList = field2.getModifierList();
        if (modifierList == null || !modifierList.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field2.getContainingClass();
        return aClass != null && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.os.Parcelable");
    }

    public boolean isImplicitRead(@NotNull PsiElement element2) {
        return false;
    }

    public boolean isImplicitWrite(@NotNull PsiElement element2) {
        if (!(element2 instanceof PsiField)) {
            return false;
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)element2);
        if (facet2 == null) {
            return false;
        }
        PsiField field2 = (PsiField)element2;
        PsiModifierList modifierList = field2.getModifierList();
        if (modifierList == null) {
            return false;
        }
        for (PsiAnnotation annotation : modifierList.getAnnotations()) {
            for (PsiNameValuePair pair : annotation.getParameterList().getAttributes()) {
                PsiAnnotationMemberValue value2 = pair.getValue();
                if (!AndroidClassMembersImplicitUsagesProvider.isResourceReference(value2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isResourceReference(@Nullable PsiAnnotationMemberValue value2) {
        if (!(value2 instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiReferenceExpression exp = (PsiReferenceExpression)value2;
        String refName = exp.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return false;
        }
        PsiExpression qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return false;
        }
        exp = (PsiReferenceExpression)qExp;
        refName = exp.getReferenceName();
        if (refName == null || refName.isEmpty()) {
            return false;
        }
        qExp = exp.getQualifierExpression();
        if (!(qExp instanceof PsiReferenceExpression)) {
            return false;
        }
        exp = (PsiReferenceExpression)qExp;
        return "R".equals(exp.getReferenceName());
    }

    public boolean isImplicitMethodUsage(PsiMethod method2) {
        for (PsiAnnotation annotation : method2.getModifierList().getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!"android.arch.lifecycle.OnLifecycleEvent".equals(qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public boolean isImplicitConstructorUsage(PsiMethod method2) {
        PsiClass aClass;
        if (!method2.isConstructor()) {
            return false;
        }
        if (!method2.hasModifierProperty("public")) {
            return false;
        }
        PsiParameterList parameterList = method2.getParameterList();
        int parameterCount = parameterList.getParametersCount();
        if (parameterCount == 0) {
            PsiClass aClass2 = method2.getContainingClass();
            return aClass2 != null && (InheritanceUtil.isInheritor((PsiClass)aClass2, (String)"android.app.Fragment") || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)SdkConstants.CLASS_V4_FRAGMENT.oldName()) || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)SdkConstants.CLASS_V4_FRAGMENT.newName()) || InheritanceUtil.isInheritor((PsiClass)aClass2, (String)"android.app.backup.BackupAgent"));
        }
        if (parameterCount < 1 || parameterCount > 3) {
            return false;
        }
        PsiParameter[] parameters2 = parameterList.getParameters();
        PsiType type = parameters2[0].getType();
        if (!(type instanceof PsiClassReferenceType)) {
            return false;
        }
        PsiClassReferenceType classType = (PsiClassReferenceType)type;
        PsiClass resolvedParameter = classType.resolve();
        if (resolvedParameter == null || !"android.content.Context".equals(resolvedParameter.getQualifiedName())) {
            return false;
        }
        if (parameterCount > 1) {
            type = parameters2[1].getType();
            if (!(type instanceof PsiClassReferenceType)) {
                return false;
            }
            classType = (PsiClassReferenceType)type;
            resolvedParameter = classType.resolve();
            if (resolvedParameter == null || !"android.util.AttributeSet".equals(resolvedParameter.getQualifiedName())) {
                return false;
            }
            if (parameterCount > 2 && !PsiType.INT.equals((Object)(type = parameters2[2].getType()))) {
                return false;
            }
        }
        if ((aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)method2, PsiClass.class)) == null) {
            return false;
        }
        PsiClass viewBaseClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("android.view.View", method2.getResolveScope());
        if (viewBaseClass == null) {
            return false;
        }
        return aClass.isInheritor(viewBaseClass, true) || parameterCount == 1 && InheritanceUtil.isInheritor((PsiClass)aClass, (String)"android.view.ActionProvider");
    }
}

