/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.property.panel.api;

import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.property.panel.api.SelectedComponentModel;
import com.android.tools.property.panel.impl.ui.ExpandableLabel;
import com.android.tools.property.panel.impl.ui.PropertyTextField;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JPanel;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/property/panel/api/SelectedComponentPanel;", "Ljavax/swing/JPanel;", "model", "Lcom/android/tools/property/panel/api/SelectedComponentModel;", "(Lcom/android/tools/property/panel/api/SelectedComponentModel;)V", "left", "Lcom/android/tools/property/panel/impl/ui/ExpandableLabel;", "right", "doLayout", "", "updateAfterModelChange", "intellij.android.layout-ui"})
public final class SelectedComponentPanel
extends JPanel {
    private final ExpandableLabel left;
    private final ExpandableLabel right;
    private final SelectedComponentModel model;

    private final void updateAfterModelChange() {
        this.left.setIcon(this.model.getIcon());
        this.left.setActualText(this.model.getId());
        this.right.setActualText(this.model.getDescription());
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.left.getX() + this.left.getWidth() > this.right.getX()) {
            Insets insets = this.getBorder().getBorderInsets(this);
            int halfWidth = Integer.max(0, (this.getWidth() - insets.left - insets.right) / 2);
            Rectangle leftBounds = this.left.getBounds();
            Rectangle rightBounds = this.right.getBounds();
            if (leftBounds.width < halfWidth) {
                rightBounds.width = halfWidth * 2 - leftBounds.width;
            } else if (rightBounds.width < halfWidth) {
                leftBounds.width = halfWidth * 2 - rightBounds.width;
            } else {
                leftBounds.width = halfWidth;
                rightBounds.width = halfWidth;
            }
            rightBounds.x = this.getWidth() - insets.right - rightBounds.width;
            this.left.setBounds(leftBounds);
            this.right.setBounds(rightBounds);
        }
    }

    public SelectedComponentPanel(@NotNull SelectedComponentModel model2) {
        super(new BorderLayout());
        this.model = model2;
        this.left = new ExpandableLabel();
        this.right = new ExpandableLabel();
        this.setBackground((Color)StudioColorsKt.getSecondaryPanelBackground());
        PropertyTextField.Companion.addBorderAtTextFieldBorderSize(this);
        this.right.setForeground((Color)new JBColor((Color)Gray._192, (Color)Gray._128));
        this.add((Component)this.left, "West");
        this.add((Component)this.right, "East");
        this.model.addValueChangedListener(new ValueChangedListener(){

            public final void valueChanged() {
                this.updateAfterModelChange();
            }
        });
        this.updateAfterModelChange();
    }
}

