/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.wizard;

import com.android.repository.io.FileOpUtils;
import com.android.tools.idea.sdk.IdeSdks;
import com.android.tools.idea.welcome.wizard.SdkComponentsStepKt;
import com.android.tools.idea.welcome.wizard.WelcomeUiUtils;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u0014\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u001a\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0007\u001a\u0012\u0010\b\u001a\u00020\u00072\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001H\u0007\u00a8\u0006\t"}, d2={"getDiskSpace", "", "path", "getExistingParentFile", "Ljava/io/File;", "getTargetFilesystem", "isExistingSdk", "", "isNonEmptyNonSdk", "intellij.android.core"})
public final class SdkComponentsStepKt {
    @Contract(value="null->null")
    @Nullable
    public static final File getExistingParentFile(@Nullable String path2) {
        Object v0;
        block2: {
            CharSequence charSequence = path2;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                return null;
            }
            Sequence $this$firstOrNull$iv = SequencesKt.generateSequence((Object)new File(path2).getAbsoluteFile(), (Function1)getExistingParentFile.1.INSTANCE);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                File p1 = (File)element$iv;
                boolean bl3 = false;
                if (!p1.exists()) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final String getDiskSpace(@Nullable String path2) {
        String string;
        File file2 = SdkComponentsStepKt.getTargetFilesystem(path2);
        if (file2 == null) {
            return "";
        }
        File file3 = file2;
        String available = WelcomeUiUtils.getSizeLabel(file3.getFreeSpace());
        if (SystemInfo.isWindows) {
            String driveName2 = ((File)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)file3, (Function1)getDiskSpace.driveName.1.INSTANCE))).getName();
            string = available + " (drive " + driveName2 + ')';
        } else {
            string = available.toString();
        }
        return string;
    }

    @Nullable
    public static final File getTargetFilesystem(@Nullable String path2) {
        File file2 = SdkComponentsStepKt.getExistingParentFile(path2);
        if (file2 == null) {
            file2 = (File)ArraysKt.firstOrNull((Object[])File.listRoots());
        }
        return file2;
    }

    @Contract(value="null->false")
    public static final boolean isExistingSdk(@Nullable String path2) {
        Object object = path2;
        boolean bl = false;
        boolean bl2 = false;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            return false;
        }
        object = new File(path2);
        bl = false;
        bl2 = false;
        Object $this$run = object;
        boolean bl3 = false;
        return ((File)$this$run).isDirectory() && IdeSdks.getInstance().isValidAndroidSdkPath((File)$this$run);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public static final boolean isNonEmptyNonSdk(@Nullable String path2) {
        if (path2 == null) {
            return false;
        }
        File file2 = new File(path2);
        if (!file2.exists()) return false;
        File[] fileArray = FileOpUtils.create().listFiles(file2);
        boolean bl = false;
        File[] fileArray2 = fileArray;
        boolean bl2 = false;
        if (fileArray2.length == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        boolean bl4 = true;
        if (!bl4) return false;
        if (AndroidSdkData.getSdkData(file2) != null) return false;
        return true;
    }
}

