/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.welcome.install;

import com.android.tools.idea.avdmanager.AccelerationErrorSolution;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.observable.core.IntProperty;
import com.android.tools.idea.observable.core.IntValueProperty;
import com.android.tools.idea.welcome.install.CpuVendor;
import com.android.tools.idea.welcome.install.FirstRunWizardDefaults;
import com.android.tools.idea.welcome.install.InstallationIntention;
import com.android.tools.idea.welcome.install.Vm;
import com.android.tools.idea.welcome.install.VmInstallerInfo;
import com.android.tools.idea.welcome.install.VmType;
import com.android.tools.idea.welcome.install.WizardException;
import com.android.tools.idea.welcome.wizard.deprecated.FirstRunWizardStep;
import com.android.tools.idea.welcome.wizard.deprecated.HaxmInstallSettingsStep;
import com.android.tools.idea.welcome.wizard.deprecated.VmUninstallInfoStep;
import com.android.tools.idea.wizard.dynamic.DynamicWizardStep;
import com.android.tools.idea.wizard.dynamic.ScopedStateStore;
import com.android.tools.idea.wizard.model.ModelWizardStep;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0011H\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u001eH\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/welcome/install/Haxm;", "Lcom/android/tools/idea/welcome/install/Vm;", "installationIntention", "Lcom/android/tools/idea/welcome/install/InstallationIntention;", "isCustomInstall", "Lcom/android/tools/idea/wizard/dynamic/ScopedStateStore$Key;", "", "(Lcom/android/tools/idea/welcome/install/InstallationIntention;Lcom/android/tools/idea/wizard/dynamic/ScopedStateStore$Key;)V", "emulatorMemoryMb", "Lcom/android/tools/idea/observable/core/IntProperty;", "filePrefix", "", "getFilePrefix", "()Ljava/lang/String;", "installUrl", "getInstallUrl", "steps", "", "Lcom/android/tools/idea/wizard/model/ModelWizardStep;", "getSteps", "()Ljava/util/Collection;", "addInstallParameters", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "cl", "memorySize", "", "createSteps", "Lcom/android/tools/idea/wizard/dynamic/DynamicWizardStep;", "getInstallCommandLine", "sdk", "Ljava/io/File;", "getMacBaseCommandLine", "source", "InstallerInfo", "intellij.android.core"})
public final class Haxm
extends Vm {
    @NotNull
    private final String installUrl = SystemInfo.isWindows ? "https://github.com/intel/haxm/wiki/Installation-Instructions-on-Windows" : "https://github.com/intel/haxm/wiki/Installation-Instructions-on-macOS";
    @NotNull
    private final String filePrefix;
    private final IntProperty emulatorMemoryMb = new IntValueProperty(FirstRunWizardDefaults.getRecommendedHaxmMemory(AvdManagerConnection.getMemorySize()));
    @NotNull
    private static final String vendor;
    @NotNull
    private static final AccelerationErrorSolution.SolutionCode installSolution;
    @NotNull
    private static final AccelerationErrorSolution.SolutionCode reinstallSolution;
    private static final boolean compatibleSystem;
    @NotNull
    private static final String componentPath;
    public static final InstallerInfo InstallerInfo;

    @Override
    @NotNull
    protected String getInstallUrl() {
        return this.installUrl;
    }

    @Override
    @NotNull
    protected String getFilePrefix() {
        return this.filePrefix;
    }

    @Override
    @NotNull
    protected GeneralCommandLine getMacBaseCommandLine(@NotNull File source) throws WizardException {
        this.ensureExistsAndIsExecutable(source, "silent_install.sh");
        File executable = this.ensureExistsAndIsExecutable(source, "HAXM installation");
        return new GeneralCommandLine(new String[]{executable.getAbsolutePath()}).withWorkDirectory(source);
    }

    @Override
    @NotNull
    public Collection<DynamicWizardStep> createSteps() {
        return SetsKt.setOf((Object)(this.installationIntention == InstallationIntention.UNINSTALL ? (FirstRunWizardStep)new VmUninstallInfoStep(VmType.HAXM) : (FirstRunWizardStep)new HaxmInstallSettingsStep(this.isCustomInstall, this.getWillBeInstalled(), this.emulatorMemoryMb)));
    }

    @Override
    @NotNull
    public Collection<ModelWizardStep<?>> getSteps() {
        return SetsKt.setOf((Object)(this.installationIntention == InstallationIntention.UNINSTALL ? (ModelWizardStep.WithoutModel)new com.android.tools.idea.welcome.wizard.VmUninstallInfoStep(VmType.HAXM) : (ModelWizardStep.WithoutModel)new com.android.tools.idea.welcome.wizard.HaxmInstallSettingsStep(this.emulatorMemoryMb)));
    }

    @Override
    @NotNull
    protected GeneralCommandLine getInstallCommandLine(@NotNull File sdk) throws WizardException, IOException {
        return this.addInstallParameters(super.getInstallCommandLine(sdk), ((Number)this.emulatorMemoryMb.get()).intValue());
    }

    private final GeneralCommandLine addInstallParameters(GeneralCommandLine cl, int memorySize) {
        cl.addParameters(new String[]{"-m", String.valueOf(memorySize)});
        return cl;
    }

    public Haxm(@NotNull InstallationIntention installationIntention, @NotNull ScopedStateStore.Key<Boolean> isCustomInstall) {
        super(InstallerInfo, installationIntention, isCustomInstall);
        this.filePrefix = "haxm";
    }

    static {
        InstallerInfo = new InstallerInfo(null);
        vendor = "intel";
        installSolution = AccelerationErrorSolution.SolutionCode.INSTALL_HAXM;
        reinstallSolution = AccelerationErrorSolution.SolutionCode.REINSTALL_HAXM;
        compatibleSystem = SystemInfo.isMac || SystemInfo.isWindows && CpuVendor.isIntel();
        componentPath = "Hardware_Accelerated_Execution_Manager";
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/welcome/install/Haxm$InstallerInfo;", "Lcom/android/tools/idea/welcome/install/VmInstallerInfo;", "()V", "compatibleSystem", "", "getCompatibleSystem", "()Z", "componentPath", "", "getComponentPath", "()Ljava/lang/String;", "installSolution", "Lcom/android/tools/idea/avdmanager/AccelerationErrorSolution$SolutionCode;", "getInstallSolution", "()Lcom/android/tools/idea/avdmanager/AccelerationErrorSolution$SolutionCode;", "reinstallSolution", "getReinstallSolution", "vendor", "getVendor", "intellij.android.core"})
    public static final class InstallerInfo
    extends VmInstallerInfo {
        @Override
        @NotNull
        public String getVendor() {
            return vendor;
        }

        @Override
        @NotNull
        public AccelerationErrorSolution.SolutionCode getInstallSolution() {
            return installSolution;
        }

        @Override
        @NotNull
        public AccelerationErrorSolution.SolutionCode getReinstallSolution() {
            return reinstallSolution;
        }

        @Override
        protected boolean getCompatibleSystem() {
            return compatibleSystem;
        }

        @Override
        @NotNull
        public String getComponentPath() {
            return componentPath;
        }

        private InstallerInfo() {
            super("Intel\u00ae HAXM");
        }

        public /* synthetic */ InstallerInfo(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

