/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesFiles {
    private PropertiesFiles() {
    }

    @NotNull
    public static Properties getProperties(@NotNull File filePath) throws IOException {
        return (Properties)ReadAction.compute(() -> {
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)filePath, (boolean)false);
            if (virtualFile == null) {
                return new Properties();
            }
            if (virtualFile.isDirectory()) {
                throw new IllegalArgumentException(String.format("The path '%1$s' belongs to a directory!", filePath.getPath()));
            }
            Properties properties2 = new Properties();
            try (InputStreamReader reader = new InputStreamReader(virtualFile.getInputStream(), StandardCharsets.UTF_8);){
                properties2.load(reader);
            }
            return properties2;
        });
    }

    public static void savePropertiesToFile(@NotNull Properties properties2, @NotNull File filePath, @Nullable String comments) throws IOException {
        WriteAction.computeAndWait(() -> {
            VirtualFile directory = VfsUtil.createDirectoryIfMissing((String)filePath.getParent());
            if (directory == null) {
                throw new IllegalStateException("Cannot find or create a VFS file for directory: " + filePath.getParent());
            }
            VirtualFile virtualFile = directory.findOrCreateChildData(PropertiesFiles.class, filePath.getName());
            try (OutputStream out = virtualFile.getOutputStream(PropertiesFiles.class);){
                properties2.store(out, comments);
            }
            return null;
        });
    }
}

