/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.surface;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.ui.LayoutEditorSettingsKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.surface.LayoutScannerControl;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlLayoutScanner;
import com.android.tools.idea.uibuilder.surface.NlLayoutScannerMetricTracker;
import com.android.tools.idea.validator.ValidatorResult;
import com.android.tools.lint.detector.api.Category;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AtfAuditResult;
import com.intellij.openapi.Disposable;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001d\u001a\u00020\u001cH\u0007J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\b\u0010\u001f\u001a\u00020\u001cH\u0007R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u00020\u00168\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0017\u0010\f\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/uibuilder/surface/NlLayoutScannerControl;", "Lcom/android/tools/idea/uibuilder/surface/LayoutScannerControl;", "surface", "Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/android/tools/idea/uibuilder/surface/NlDesignSurface;Lcom/intellij/openapi/Disposable;)V", "issueExpandListener", "Lcom/android/tools/idea/common/error/IssuePanel$ExpandListener;", "issuePanelListener", "Lcom/android/tools/idea/common/error/IssuePanel$MinimizeListener;", "getIssuePanelListener$annotations", "()V", "getIssuePanelListener", "()Lcom/android/tools/idea/common/error/IssuePanel$MinimizeListener;", "metricTracker", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScannerMetricTracker;", "scanner", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner;", "getScanner", "()Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner;", "scannerListener", "Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner$Listener;", "getScannerListener$annotations", "getScannerListener", "()Lcom/android/tools/idea/uibuilder/surface/NlLayoutScanner$Listener;", "scannerResult", "Ljava/util/concurrent/CompletableFuture;", "", "hasA11yIssue", "runLayoutScanner", "tryRefreshWithScanner", "intellij.android.designer"})
public final class NlLayoutScannerControl
implements LayoutScannerControl {
    private final NlLayoutScannerMetricTracker metricTracker;
    @NotNull
    private final NlLayoutScanner scanner;
    private CompletableFuture<Boolean> scannerResult;
    @NotNull
    private final IssuePanel.MinimizeListener issuePanelListener;
    private final IssuePanel.ExpandListener issueExpandListener;
    @NotNull
    private final NlLayoutScanner.Listener scannerListener;
    private final NlDesignSurface surface;

    @Override
    @NotNull
    public NlLayoutScanner getScanner() {
        return this.scanner;
    }

    @VisibleForTesting
    public static /* synthetic */ void getIssuePanelListener$annotations() {
    }

    @NotNull
    public final IssuePanel.MinimizeListener getIssuePanelListener() {
        return this.issuePanelListener;
    }

    @VisibleForTesting
    public static /* synthetic */ void getScannerListener$annotations() {
    }

    @NotNull
    public final NlLayoutScanner.Listener getScannerListener() {
        return this.scannerListener;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> runLayoutScanner() {
        this.getScanner().addListener(this.scannerListener);
        if (!this.tryRefreshWithScanner()) {
            return CompletableFuture.completedFuture(false);
        }
        this.scannerResult = new CompletableFuture();
        this.metricTracker.trackTrigger(AtfAuditResult.Trigger.USER);
        CompletableFuture<Boolean> completableFuture = this.scannerResult;
        if (completableFuture == null) {
            Intrinsics.throwNpe();
        }
        return completableFuture;
    }

    @VisibleForTesting
    public final boolean tryRefreshWithScanner() {
        LayoutlibSceneManager layoutlibSceneManager = this.surface.getSceneManager();
        if (layoutlibSceneManager == null) {
            return false;
        }
        LayoutlibSceneManager manager = layoutlibSceneManager;
        manager.getLayoutScannerConfig().setLayoutScannerEnabled(true);
        manager.forceReinflate();
        this.surface.requestRender();
        return true;
    }

    @VisibleForTesting
    public final boolean hasA11yIssue() {
        Collection collection2 = this.getScanner().getIssues();
        boolean bl = false;
        if (!collection2.isEmpty()) {
            return true;
        }
        Iterable $this$forEach$iv = (Iterable)this.surface.getIssueModel().getIssues();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Issue it = (Issue)element$iv;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)Category.A11Y.getName(), (Object)it.getCategory())) continue;
            return true;
        }
        return false;
    }

    public NlLayoutScannerControl(@NotNull NlDesignSurface surface2, @NotNull Disposable disposable2) {
        this.surface = surface2;
        this.metricTracker = new NlLayoutScannerMetricTracker(this.surface);
        this.scanner = new NlLayoutScanner(this.surface.getIssueModel(), disposable2, this.metricTracker);
        this.issuePanelListener = new IssuePanel.MinimizeListener(this){
            final /* synthetic */ NlLayoutScannerControl this$0;

            public final void onMinimizeChanged(boolean it) {
                Object object = NlLayoutScannerControl.access$getSurface$p(this.this$0).getSceneManager();
                if (object == null || (object = ((LayoutlibSceneManager)object).getLayoutScannerConfig()) == null) {
                    return;
                }
                Object check2 = object;
                if (it) {
                    if (!LayoutEditorSettingsKt.getAlwaysEnableLayoutScanner()) {
                        this.this$0.getScanner().disable();
                        check2.setLayoutScannerEnabled(false);
                    }
                    NlLayoutScannerControl.access$getMetricTracker$p(this.this$0).trackIssuePanelClosed();
                } else if (!check2.isLayoutScannerEnabled()) {
                    NlLayoutScannerControl.access$getMetricTracker$p(this.this$0).trackTrigger(AtfAuditResult.Trigger.ISSUE_PANEL);
                    this.this$0.tryRefreshWithScanner();
                }
            }
            {
                this.this$0 = nlLayoutScannerControl;
            }
        };
        this.issueExpandListener = new IssuePanel.ExpandListener(this){
            final /* synthetic */ NlLayoutScannerControl this$0;

            public final void onExpanded(Issue issue2, boolean expanded) {
                if (this.this$0.getScanner().getIssues().contains(issue2)) {
                    NlLayoutScannerControl.access$getMetricTracker$p(this.this$0).trackIssueExpanded(issue2, expanded);
                }
            }
            {
                this.this$0 = nlLayoutScannerControl;
            }
        };
        this.scannerListener = new NlLayoutScanner.Listener(this){
            final /* synthetic */ NlLayoutScannerControl this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void lintUpdated(@Nullable ValidatorResult result2) {
                try {
                    if (!this.this$0.hasA11yIssue()) {
                        CompletableFuture completableFuture = NlLayoutScannerControl.access$getScannerResult$p(this.this$0);
                        if (completableFuture != null) {
                            completableFuture.complete(false);
                        }
                        return;
                    }
                    NlLayoutScannerControl.access$getSurface$p(this.this$0).getAnalyticsManager().trackShowIssuePanel();
                    NlLayoutScannerControl.access$getSurface$p(this.this$0).setShowIssuePanel(true, false);
                    CompletableFuture completableFuture = NlLayoutScannerControl.access$getScannerResult$p(this.this$0);
                    if (completableFuture != null) {
                        completableFuture.complete(true);
                    }
                }
                finally {
                    this.this$0.getScanner().removeListener(this);
                    NlLayoutScannerControl.access$setScannerResult$p(this.this$0, null);
                }
            }
            {
                this.this$0 = this$0;
            }
        };
        this.surface.getIssuePanel().addMinimizeListener(this.issuePanelListener);
        this.surface.getIssuePanel().setExpandListener(this.issueExpandListener);
    }

    public static final /* synthetic */ NlDesignSurface access$getSurface$p(NlLayoutScannerControl $this) {
        return $this.surface;
    }

    public static final /* synthetic */ NlLayoutScannerMetricTracker access$getMetricTracker$p(NlLayoutScannerControl $this) {
        return $this.metricTracker;
    }

    public static final /* synthetic */ CompletableFuture access$getScannerResult$p(NlLayoutScannerControl $this) {
        return $this.scannerResult;
    }

    public static final /* synthetic */ void access$setScannerResult$p(NlLayoutScannerControl $this, CompletableFuture completableFuture) {
        $this.scannerResult = completableFuture;
    }
}

