/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.structure.DelegatedTreeEventHandler;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.structure.NlTreeUtil;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TreeTransferHandler
extends TransferHandler {
    @Override
    public int getSourceActions(JComponent c) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        NlComponentTree tree = (NlComponentTree)((Object)c);
        this.setDragImage(TreeTransferHandler.getDragImageOfSelection(tree));
        Scene scene = tree.getScene();
        if (scene != null && !scene.getDesignSurface().getSelectionModel().isEmpty()) {
            return scene.getDesignSurface().getSelectionAsTransferable();
        }
        return TreeTransferHandler.delegateTransfer(tree);
    }

    private static Transferable delegateTransfer(NlComponentTree tree) {
        DelegatedTreeEventHandler handler2 = NlTreeUtil.getSelectionTreeHandler(tree);
        TreePath[] selectionPaths = tree.getSelectionModel().getSelectionPaths();
        return handler2 != null ? handler2.getTransferable(selectionPaths) : null;
    }

    @Override
    protected void exportDone(JComponent c, Transferable transferable, int dropAction) {
        if (dropAction == 2) {
            NlComponentTree tree = (NlComponentTree)((Object)c);
            NlModel model2 = tree.getDesignerModel();
            List<NlComponent> selected = tree.getSelectedComponents();
            if (model2 != null && !selected.isEmpty()) {
                ApplicationManager.getApplication().invokeLater(() -> model2.delete(selected));
            }
        }
    }

    @Nullable
    private static Image getDragImageOfSelection(@NotNull NlComponentTree tree) {
        TreePath[] paths = tree.getSelectionPaths();
        if (paths == null) {
            return null;
        }
        int width = 0;
        int height = 0;
        for (TreePath path2 : paths) {
            int row = tree.getRowForPath(path2);
            Component component = tree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)tree), path2.getLastPathComponent(), false, true, true, row, false);
            Dimension size = component.getPreferredSize();
            width = Math.max(width, size.width);
            height += size.height;
        }
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        for (TreePath path3 : paths) {
            int row = tree.getRowForPath(path3);
            Component component = tree.getCellRenderer().getTreeCellRendererComponent((JTree)((Object)tree), path3.getLastPathComponent(), false, true, true, row, false);
            Dimension size = component.getPreferredSize();
            component.setSize(size);
            g2.setComposite(AlphaComposite.getInstance(3, 0.7f));
            if (!((Boolean)StudioFlags.NELE_DRAG_PLACEHOLDER.get()).booleanValue()) {
                component.paint(g2);
            }
            g2.translate(0, size.height);
        }
        g2.dispose();
        return image;
    }
}

